/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.expression.DerivedLiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.expression.DerivedParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValue;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValuesToken;

public final class GeneratedKeyInsertValuesTokenGenerator
extends BaseGeneratedKeyTokenGenerator
implements PreviousSQLTokensAware {
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLToken(InsertStatement insertStatement) {
        return !insertStatement.getValues().isEmpty();
    }

    public SQLToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional<InsertValuesToken> result = this.findPreviousSQLToken();
        Preconditions.checkState((boolean)result.isPresent());
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        Iterator generatedValues = ((GeneratedKeyContext)generatedKey.get()).getGeneratedValues().descendingIterator();
        int count = 0;
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            InsertValue insertValueToken = (InsertValue)result.get().getInsertValues().get(count);
            DerivedLiteralExpressionSegment expressionSegment = this.isToAddDerivedLiteralExpression(insertStatementContext, count) ? new DerivedLiteralExpressionSegment(generatedValues.next()) : new DerivedParameterMarkerExpressionSegment(each.getParametersCount());
            insertValueToken.getValues().add(expressionSegment);
            ++count;
        }
        return (SQLToken)result.get();
    }

    private Optional<InsertValuesToken> findPreviousSQLToken() {
        for (SQLToken each : this.previousSQLTokens) {
            if (!(each instanceof InsertValuesToken)) continue;
            return Optional.of((InsertValuesToken)each);
        }
        return Optional.empty();
    }

    private boolean isToAddDerivedLiteralExpression(InsertStatementContext insertStatementContext, int insertValueCount) {
        return ((List)insertStatementContext.getGroupedParameters().get(insertValueCount)).isEmpty();
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

