/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.GeneratedKeyInsertColumnToken;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;

public final class GeneratedKeyInsertColumnTokenGenerator
extends BaseGeneratedKeyTokenGenerator {
    @Override
    protected boolean isGenerateSQLToken(InsertStatement insertStatement) {
        Optional sqlSegment = insertStatement.getInsertColumns();
        return sqlSegment.isPresent() && !((InsertColumnsSegment)sqlSegment.get()).getColumns().isEmpty();
    }

    public GeneratedKeyInsertColumnToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        Optional sqlSegment = ((InsertStatement)insertStatementContext.getSqlStatement()).getInsertColumns();
        Preconditions.checkState((boolean)sqlSegment.isPresent());
        return new GeneratedKeyInsertColumnToken(((InsertColumnsSegment)sqlSegment.get()).getStopIndex(), ((GeneratedKeyContext)generatedKey.get()).getColumnName());
    }
}

