/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.GeneratedKeyAssignmentToken;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.LiteralGeneratedKeyAssignmentToken;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ParameterMarkerGeneratedKeyAssignmentToken;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.ParametersAware;

public final class GeneratedKeyAssignmentTokenGenerator
extends BaseGeneratedKeyTokenGenerator
implements ParametersAware {
    private List<Object> parameters;

    @Override
    protected boolean isGenerateSQLToken(InsertStatement insertStatement) {
        return insertStatement.getSetAssignment().isPresent();
    }

    public GeneratedKeyAssignmentToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        Preconditions.checkState((boolean)((InsertStatement)insertStatementContext.getSqlStatement()).getSetAssignment().isPresent());
        int startIndex = ((SetAssignmentSegment)((InsertStatement)insertStatementContext.getSqlStatement()).getSetAssignment().get()).getStopIndex() + 1;
        return this.parameters.isEmpty() ? new LiteralGeneratedKeyAssignmentToken(startIndex, ((GeneratedKeyContext)generatedKey.get()).getColumnName(), ((GeneratedKeyContext)generatedKey.get()).getGeneratedValues().getLast()) : new ParameterMarkerGeneratedKeyAssignmentToken(startIndex, ((GeneratedKeyContext)generatedKey.get()).getColumnName());
    }

    @Generated
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }
}

