/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.aware.ShardingRuleAware;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.TableToken;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;

public final class TableTokenGenerator
implements CollectionSQLTokenGenerator,
ShardingRuleAware {
    private ShardingRule shardingRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return true;
    }

    public Collection<TableToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof TableAvailable ? this.generateSQLTokens((TableAvailable)sqlStatementContext) : Collections.emptyList();
    }

    private Collection<TableToken> generateSQLTokens(TableAvailable sqlStatementContext) {
        LinkedList<TableToken> result = new LinkedList<TableToken>();
        for (SimpleTableSegment each : sqlStatementContext.getAllTables()) {
            if (!this.shardingRule.findTableRule(each.getTableName().getIdentifier().getValue()).isPresent()) continue;
            result.add(new TableToken(each.getStartIndex(), each.getStopIndex(), each.getTableName().getIdentifier(), (SQLStatementContext)sqlStatementContext, this.shardingRule));
        }
        return result;
    }

    @Generated
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

