/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ProjectionsToken;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.OptionalSQLTokenGenerator;

public final class ProjectionsTokenGenerator
implements OptionalSQLTokenGenerator<SelectStatementContext>,
IgnoreForSingleRoute {
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !this.getDerivedProjectionTexts((SelectStatementContext)sqlStatementContext).isEmpty();
    }

    public ProjectionsToken generateSQLToken(SelectStatementContext selectStatementContext) {
        Collection<String> derivedProjectionTexts = this.getDerivedProjectionTexts(selectStatementContext);
        return new ProjectionsToken(selectStatementContext.getProjectionsContext().getStopIndex() + 1 + " ".length(), derivedProjectionTexts);
    }

    private Collection<String> getDerivedProjectionTexts(SelectStatementContext selectStatementContext) {
        LinkedList<String> result = new LinkedList<String>();
        for (Projection each : selectStatementContext.getProjectionsContext().getProjections()) {
            if (each instanceof AggregationProjection && !((AggregationProjection)each).getDerivedAggregationProjections().isEmpty()) {
                result.addAll(((AggregationProjection)each).getDerivedAggregationProjections().stream().map(this::getDerivedProjectionText).collect(Collectors.toList()));
                continue;
            }
            if (!(each instanceof DerivedProjection)) continue;
            result.add(this.getDerivedProjectionText(each));
        }
        return result;
    }

    private String getDerivedProjectionText(Projection projection) {
        Preconditions.checkState((boolean)projection.getAlias().isPresent());
        if (projection instanceof AggregationDistinctProjection) {
            return ((AggregationDistinctProjection)projection).getDistinctInnerExpression() + " AS " + (String)projection.getAlias().get() + " ";
        }
        return projection.getExpression() + " AS " + (String)projection.getAlias().get() + " ";
    }
}

