/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.parameter.impl;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.underlying.route.context.RouteContext;

public final class ShardingPaginationParameterRewriter
implements ParameterRewriter<SelectStatementContext>,
RouteContextAware {
    private RouteContext routeContext;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getPaginationContext().isHasPagination() && !this.routeContext.getRouteResult().isSingleRouting();
    }

    public void rewrite(ParameterBuilder parameterBuilder, SelectStatementContext selectStatementContext, List<Object> parameters) {
        PaginationContext pagination = selectStatementContext.getPaginationContext();
        pagination.getOffsetParameterIndex().ifPresent(offsetParameterIndex -> this.rewriteOffset(pagination, (int)offsetParameterIndex, (StandardParameterBuilder)parameterBuilder));
        pagination.getRowCountParameterIndex().ifPresent(rowCountParameterIndex -> this.rewriteRowCount(pagination, (int)rowCountParameterIndex, (StandardParameterBuilder)parameterBuilder, (SQLStatementContext)selectStatementContext));
    }

    private void rewriteOffset(PaginationContext pagination, int offsetParameterIndex, StandardParameterBuilder parameterBuilder) {
        parameterBuilder.addReplacedParameters(offsetParameterIndex, (Object)pagination.getRevisedOffset());
    }

    private void rewriteRowCount(PaginationContext pagination, int rowCountParameterIndex, StandardParameterBuilder parameterBuilder, SQLStatementContext sqlStatementContext) {
        parameterBuilder.addReplacedParameters(rowCountParameterIndex, (Object)pagination.getRevisedRowCount((SelectStatementContext)sqlStatementContext));
    }

    @Generated
    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

