/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.parameter.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.rewriter.ParameterRewriter;

public final class ShardingGeneratedKeyInsertValueParameterRewriter
implements ParameterRewriter<InsertStatementContext> {
    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatementContext)sqlStatementContext).getGeneratedKeyContext().isPresent() && ((GeneratedKeyContext)((InsertStatementContext)sqlStatementContext).getGeneratedKeyContext().get()).isGenerated();
    }

    public void rewrite(ParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, List<Object> parameters) {
        Preconditions.checkState((boolean)insertStatementContext.getGeneratedKeyContext().isPresent());
        ((GroupedParameterBuilder)parameterBuilder).setDerivedColumnName(((GeneratedKeyContext)insertStatementContext.getGeneratedKeyContext().get()).getColumnName());
        Iterator generatedValues = ((GeneratedKeyContext)insertStatementContext.getGeneratedKeyContext().get()).getGeneratedValues().descendingIterator();
        int count = 0;
        int parametersCount = 0;
        for (List each : insertStatementContext.getGroupedParameters()) {
            parametersCount += ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getParametersCount();
            Comparable generatedValue = (Comparable)generatedValues.next();
            if (!each.isEmpty()) {
                ((StandardParameterBuilder)((GroupedParameterBuilder)parameterBuilder).getParameterBuilders().get(count)).addAddedParameters(parametersCount, (Collection)Lists.newArrayList((Object[])new Object[]{generatedValue}));
            }
            ++count;
        }
    }
}

