/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.complex.ComplexExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.Alterable;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.core.route.type.RoutingUnit;
import org.apache.shardingsphere.core.rule.DataNode;

public final class InsertValuesToken
extends SQLToken
implements Substitutable,
Alterable {
    private final int stopIndex;
    private final List<InsertValueToken> insertValueTokens;

    public InsertValuesToken(int startIndex, int stopIndex) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.insertValueTokens = new LinkedList<InsertValueToken>();
    }

    @Override
    public String toString(RoutingUnit routingUnit, Map<String, String> logicAndActualTables) {
        StringBuilder result = new StringBuilder();
        this.appendInsertValue(routingUnit, result);
        result.delete(result.length() - 2, result.length());
        return result.toString();
    }

    private void appendInsertValue(RoutingUnit routingUnit, StringBuilder stringBuilder) {
        for (InsertValueToken each : this.insertValueTokens) {
            if (!this.isAppend(routingUnit, each)) continue;
            stringBuilder.append(each).append(", ");
        }
    }

    private boolean isAppend(RoutingUnit routingUnit, InsertValueToken insertValueToken) {
        if (insertValueToken.getDataNodes().isEmpty() || null == routingUnit) {
            return true;
        }
        for (DataNode each : insertValueToken.getDataNodes()) {
            if (!routingUnit.getTableUnit(each.getDataSourceName(), each.getTableName()).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public List<InsertValueToken> getInsertValueTokens() {
        return this.insertValueTokens;
    }

    public static final class InsertValueToken {
        private final List<ExpressionSegment> values;
        private final Collection<DataNode> dataNodes;

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("(");
            for (int i = 0; i < this.values.size(); ++i) {
                result.append(this.getValue(i)).append(", ");
            }
            result.delete(result.length() - 2, result.length()).append(")");
            return result.toString();
        }

        private String getValue(int index) {
            ExpressionSegment expressionSegment = this.values.get(index);
            if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
                return "?";
            }
            if (expressionSegment instanceof LiteralExpressionSegment) {
                Object literals = ((LiteralExpressionSegment)expressionSegment).getLiterals();
                return literals instanceof String ? String.format("'%s'", ((LiteralExpressionSegment)expressionSegment).getLiterals()) : literals.toString();
            }
            return ((ComplexExpressionSegment)expressionSegment).getText();
        }

        @ConstructorProperties(value={"values", "dataNodes"})
        public InsertValueToken(List<ExpressionSegment> values, Collection<DataNode> dataNodes) {
            this.values = values;
            this.dataNodes = dataNodes;
        }

        public List<ExpressionSegment> getValues() {
            return this.values;
        }

        public Collection<DataNode> getDataNodes() {
            return this.dataNodes;
        }
    }
}

