/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.sql.token.generator;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.TableMetasAware;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.SQLToken;

public final class SQLTokenGenerators {
    private final Collection<SQLTokenGenerator> sqlTokenGenerators = new LinkedList<SQLTokenGenerator>();

    public void addAll(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        for (SQLTokenGenerator each : sqlTokenGenerators) {
            if (this.containsClass(each)) continue;
            this.sqlTokenGenerators.add(each);
        }
    }

    private boolean containsClass(SQLTokenGenerator sqlTokenGenerator) {
        for (SQLTokenGenerator each : this.sqlTokenGenerators) {
            if (each.getClass() != sqlTokenGenerator.getClass()) continue;
            return true;
        }
        return false;
    }

    public List<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext, List<Object> parameters, TableMetas tableMetas) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (SQLTokenGenerator each : this.sqlTokenGenerators) {
            this.setUpSQLTokenGenerator(each, parameters, tableMetas, result);
            if (!each.isGenerateSQLToken(sqlStatementContext)) continue;
            if (each instanceof OptionalSQLTokenGenerator) {
                SQLToken sqlToken = ((OptionalSQLTokenGenerator)each).generateSQLToken(sqlStatementContext);
                if (result.contains(sqlToken)) continue;
                result.add(sqlToken);
                continue;
            }
            if (!(each instanceof CollectionSQLTokenGenerator)) continue;
            result.addAll(((CollectionSQLTokenGenerator)each).generateSQLTokens(sqlStatementContext));
        }
        return result;
    }

    private void setUpSQLTokenGenerator(SQLTokenGenerator sqlTokenGenerator, List<Object> parameters, TableMetas tableMetas, List<SQLToken> previousSQLTokens) {
        if (sqlTokenGenerator instanceof ParametersAware) {
            ((ParametersAware)((Object)sqlTokenGenerator)).setParameters(parameters);
        }
        if (sqlTokenGenerator instanceof TableMetasAware) {
            ((TableMetasAware)((Object)sqlTokenGenerator)).setTableMetas(tableMetas);
        }
        if (sqlTokenGenerator instanceof PreviousSQLTokensAware) {
            ((PreviousSQLTokensAware)((Object)sqlTokenGenerator)).setPreviousSQLTokens(previousSQLTokens);
        }
    }
}

