/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.sql;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.Alterable;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.core.route.type.RoutingUnit;

public final class SQLBuilder {
    private final String logicSQL;
    private final List<SQLToken> sqlTokens;

    public String toSQL() {
        return this.toSQL(null, Collections.emptyMap());
    }

    public String toSQL(RoutingUnit routingUnit, Map<String, String> logicAndActualTables) {
        if (this.sqlTokens.isEmpty()) {
            return this.logicSQL;
        }
        Collections.sort(this.sqlTokens);
        StringBuilder result = new StringBuilder();
        result.append(this.logicSQL.substring(0, this.sqlTokens.get(0).getStartIndex()));
        for (SQLToken each : this.sqlTokens) {
            result.append(this.getSQLTokenText(each, routingUnit, logicAndActualTables));
            result.append(this.getConjunctionText(each));
        }
        return result.toString();
    }

    private String getSQLTokenText(SQLToken sqlToken, RoutingUnit routingUnit, Map<String, String> logicAndActualTables) {
        return sqlToken instanceof Alterable ? ((Alterable)((Object)sqlToken)).toString(routingUnit, logicAndActualTables) : sqlToken.toString();
    }

    private String getConjunctionText(SQLToken sqlToken) {
        return this.logicSQL.substring(this.getStartIndex(sqlToken), this.getStopIndex(sqlToken));
    }

    private int getStartIndex(SQLToken sqlToken) {
        int startIndex = sqlToken instanceof Substitutable ? ((Substitutable)((Object)sqlToken)).getStopIndex() + 1 : sqlToken.getStartIndex();
        return startIndex > this.logicSQL.length() ? this.logicSQL.length() : startIndex;
    }

    private int getStopIndex(SQLToken sqlToken) {
        int currentSQLTokenIndex = this.sqlTokens.indexOf(sqlToken);
        return this.sqlTokens.size() - 1 == currentSQLTokenIndex ? this.logicSQL.length() : this.sqlTokens.get(currentSQLTokenIndex + 1).getStartIndex();
    }

    @ConstructorProperties(value={"logicSQL", "sqlTokens"})
    public SQLBuilder(String logicSQL, List<SQLToken> sqlTokens) {
        this.logicSQL = logicSQL;
        this.sqlTokens = sqlTokens;
    }
}

