/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.parameter.builder.impl;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;

public final class StandardParameterBuilder
implements ParameterBuilder {
    private final List<Object> originalParameters;
    private final Map<Integer, Collection<Object>> addedIndexAndParameters = new TreeMap<Integer, Collection<Object>>();
    private final Map<Integer, Object> replacedIndexAndParameters = new LinkedHashMap<Integer, Object>();

    public void addAddedParameters(int index, Collection<Object> parameters) {
        this.addedIndexAndParameters.put(index, parameters);
    }

    public void addReplacedParameters(int index, Object parameter) {
        this.replacedIndexAndParameters.put(index, parameter);
    }

    @Override
    public List<Object> getParameters() {
        LinkedList<Object> result = new LinkedList<Object>(this.originalParameters);
        for (Map.Entry<Integer, Object> entry : this.replacedIndexAndParameters.entrySet()) {
            result.set(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : ((TreeMap)this.addedIndexAndParameters).descendingMap().entrySet()) {
            if (entry.getKey() > result.size()) {
                result.addAll((Collection)entry.getValue());
                continue;
            }
            result.addAll(entry.getKey(), (Collection)entry.getValue());
        }
        return result;
    }

    @ConstructorProperties(value={"originalParameters"})
    public StandardParameterBuilder(List<Object> originalParameters) {
        this.originalParameters = originalParameters;
    }

    public Map<Integer, Collection<Object>> getAddedIndexAndParameters() {
        return this.addedIndexAndParameters;
    }
}

