/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.parameter.builder.impl;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.StandardParameterBuilder;

public final class GroupedParameterBuilder
implements ParameterBuilder {
    private final List<StandardParameterBuilder> parameterBuilders;
    private String derivedColumnName;

    public GroupedParameterBuilder(List<List<Object>> groupedParameters) {
        this.parameterBuilders = new ArrayList<StandardParameterBuilder>(groupedParameters.size());
        for (List<Object> each : groupedParameters) {
            this.parameterBuilders.add(new StandardParameterBuilder(each));
        }
    }

    @Override
    public List<Object> getParameters() {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int i = 0; i < this.parameterBuilders.size(); ++i) {
            result.addAll(this.getParameters(i));
        }
        return result;
    }

    public List<Object> getParameters(int count) {
        return this.parameterBuilders.get(count).getParameters();
    }

    public Optional<String> getDerivedColumnName() {
        return Optional.fromNullable((Object)this.derivedColumnName);
    }

    public List<StandardParameterBuilder> getParameterBuilders() {
        return this.parameterBuilders;
    }

    public void setDerivedColumnName(String derivedColumnName) {
        this.derivedColumnName = derivedColumnName;
    }
}

