/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo;

import com.google.common.base.Joiner;
import java.util.Map;
import org.apache.shardingsphere.core.parse.core.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.util.SQLUtil;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.Alterable;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.core.route.type.RoutingUnit;

public final class TableToken
extends SQLToken
implements Substitutable,
Alterable {
    private final int stopIndex;
    private final String tableName;
    private final QuoteCharacter quoteCharacter;

    public TableToken(int startIndex, int stopIndex, String tableName, QuoteCharacter quoteCharacter) {
        super(startIndex);
        this.tableName = SQLUtil.getExactlyValue((String)tableName);
        this.quoteCharacter = quoteCharacter;
        this.stopIndex = stopIndex;
    }

    @Override
    public String toString(RoutingUnit routingUnit, Map<String, String> logicAndActualTables) {
        String actualTableName = logicAndActualTables.get(this.tableName.toLowerCase());
        actualTableName = null == actualTableName ? this.tableName.toLowerCase() : actualTableName;
        return Joiner.on((String)"").join((Object)this.quoteCharacter.getStartDelimiter(), (Object)actualTableName, new Object[]{this.quoteCharacter.getEndDelimiter()});
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }
}

