/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo;

import java.util.Map;
import org.apache.shardingsphere.core.parse.core.constant.QuoteCharacter;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.Alterable;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.core.route.type.RoutingUnit;

public final class IndexToken
extends SQLToken
implements Substitutable,
Alterable {
    private final int stopIndex;
    private final String indexName;
    private final QuoteCharacter quoteCharacter;

    public IndexToken(int startIndex, int stopIndex, String indexName, QuoteCharacter quoteCharacter) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.indexName = indexName;
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    public String toString(RoutingUnit routingUnit, Map<String, String> logicAndActualTables) {
        StringBuilder result = new StringBuilder();
        result.append(this.quoteCharacter.getStartDelimiter()).append(this.indexName);
        if (!logicAndActualTables.isEmpty()) {
            result.append("_").append(logicAndActualTables.values().iterator().next());
        }
        result.append(this.quoteCharacter.getEndDelimiter());
        return result.toString();
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }
}

