/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.core.parse.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.preprocessor.segment.insert.InsertValueContext;
import org.apache.shardingsphere.core.preprocessor.segment.insert.expression.DerivedLiteralExpressionSegment;
import org.apache.shardingsphere.core.preprocessor.segment.insert.expression.DerivedParameterMarkerExpressionSegment;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.core.route.router.sharding.keygen.GeneratedKey;

public final class GeneratedKeyInsertValuesTokenGenerator
extends BaseGeneratedKeyTokenGenerator
implements OptionalSQLTokenGenerator,
PreviousSQLTokensAware {
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLToken(InsertStatement insertStatement) {
        return !insertStatement.findSQLSegments(InsertValuesSegment.class).isEmpty();
    }

    @Override
    protected SQLToken generateSQLToken(SQLStatementContext sqlStatementContext, GeneratedKey generatedKey) {
        Optional<InsertValuesToken> result = this.findPreviousSQLToken();
        Preconditions.checkState((boolean)result.isPresent());
        Iterator generatedValues = generatedKey.getGeneratedValues().descendingIterator();
        int count = 0;
        for (InsertValueContext each : ((InsertSQLStatementContext)sqlStatementContext).getInsertValueContexts()) {
            InsertValuesToken.InsertValueToken insertValueToken = ((InsertValuesToken)result.get()).getInsertValueTokens().get(count);
            DerivedLiteralExpressionSegment expressionSegment = this.isToAddDerivedLiteralExpression((InsertSQLStatementContext)sqlStatementContext, count) ? new DerivedLiteralExpressionSegment(generatedValues.next()) : new DerivedParameterMarkerExpressionSegment(each.getParametersCount());
            insertValueToken.getValues().add((ExpressionSegment)expressionSegment);
            ++count;
        }
        return (SQLToken)result.get();
    }

    private Optional<InsertValuesToken> findPreviousSQLToken() {
        for (SQLToken each : this.previousSQLTokens) {
            if (!(each instanceof InsertValuesToken)) continue;
            return Optional.of((Object)((InsertValuesToken)each));
        }
        return Optional.absent();
    }

    private boolean isToAddDerivedLiteralExpression(InsertSQLStatementContext insertSQLStatementContext, int insertValueCount) {
        return ((List)insertSQLStatementContext.getGroupedParameters().get(insertValueCount)).isEmpty();
    }

    @Override
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

