/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.shardingsphere.core.parse.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.core.parse.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.GeneratedKeyInsertColumnToken;
import org.apache.shardingsphere.core.route.router.sharding.keygen.GeneratedKey;

public final class GeneratedKeyInsertColumnTokenGenerator
extends BaseGeneratedKeyTokenGenerator {
    @Override
    protected boolean isGenerateSQLToken(InsertStatement insertStatement) {
        Optional sqlSegment = insertStatement.findSQLSegment(InsertColumnsSegment.class);
        return sqlSegment.isPresent() && !((InsertColumnsSegment)sqlSegment.get()).getColumns().isEmpty();
    }

    @Override
    protected GeneratedKeyInsertColumnToken generateSQLToken(SQLStatementContext sqlStatementContext, GeneratedKey generatedKey) {
        Optional sqlSegment = sqlStatementContext.getSqlStatement().findSQLSegment(InsertColumnsSegment.class);
        Preconditions.checkState((boolean)sqlSegment.isPresent());
        return new GeneratedKeyInsertColumnToken(((InsertColumnsSegment)sqlSegment.get()).getStopIndex(), generatedKey.getColumnName());
    }
}

