/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.shardingsphere.core.parse.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.core.parse.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic.UseDefaultInsertColumnsToken;
import org.apache.shardingsphere.core.route.router.sharding.keygen.GeneratedKey;

public final class GeneratedKeyForUseDefaultInsertColumnsTokenGenerator
extends BaseGeneratedKeyTokenGenerator {
    @Override
    protected boolean isGenerateSQLToken(InsertStatement insertStatement) {
        return insertStatement.useDefaultColumns();
    }

    @Override
    protected UseDefaultInsertColumnsToken generateSQLToken(SQLStatementContext sqlStatementContext, GeneratedKey generatedKey) {
        Optional insertColumnsSegment = sqlStatementContext.getSqlStatement().findSQLSegment(InsertColumnsSegment.class);
        Preconditions.checkState((boolean)insertColumnsSegment.isPresent());
        return new UseDefaultInsertColumnsToken(((InsertColumnsSegment)insertColumnsSegment.get()).getStopIndex(), this.getColumnNames((InsertSQLStatementContext)sqlStatementContext, generatedKey));
    }

    private List<String> getColumnNames(InsertSQLStatementContext sqlStatementContext, GeneratedKey generatedKey) {
        ArrayList<String> result = new ArrayList<String>(sqlStatementContext.getColumnNames());
        result.remove(generatedKey.getColumnName());
        result.add(generatedKey.getColumnName());
        return result;
    }
}

