/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.shardingsphere.core.parse.sql.segment.dml.assignment.SetAssignmentsSegment;
import org.apache.shardingsphere.core.parse.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.GeneratedKeyAssignmentToken;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.LiteralGeneratedKeyAssignmentToken;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.ParameterMarkerGeneratedKeyAssignmentToken;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.core.route.router.sharding.keygen.GeneratedKey;

public final class GeneratedKeyAssignmentTokenGenerator
extends BaseGeneratedKeyTokenGenerator
implements ParametersAware {
    private List<Object> parameters;

    @Override
    protected boolean isGenerateSQLToken(InsertStatement insertStatement) {
        return insertStatement.getSetAssignment().isPresent();
    }

    @Override
    protected GeneratedKeyAssignmentToken generateSQLToken(SQLStatementContext sqlStatementContext, GeneratedKey generatedKey) {
        Preconditions.checkState((boolean)((InsertStatement)sqlStatementContext.getSqlStatement()).getSetAssignment().isPresent());
        int startIndex = ((SetAssignmentsSegment)((InsertStatement)sqlStatementContext.getSqlStatement()).getSetAssignment().get()).getStopIndex() + 1;
        return this.parameters.isEmpty() ? new LiteralGeneratedKeyAssignmentToken(startIndex, generatedKey.getColumnName(), generatedKey.getGeneratedValues().getLast()) : new ParameterMarkerGeneratedKeyAssignmentToken(startIndex, generatedKey.getColumnName());
    }

    @Override
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }
}

