/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.parse.sql.segment.SQLSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.item.SelectItemsSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.item.ShorthandSelectItemSegment;
import org.apache.shardingsphere.core.parse.sql.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.core.parse.sql.segment.generic.TableAvailable;
import org.apache.shardingsphere.core.parse.sql.segment.generic.TableSegment;
import org.apache.shardingsphere.core.parse.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.preprocessor.segment.table.Table;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.aware.ShardingRuleAware;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.TableToken;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class TableTokenGenerator
implements CollectionSQLTokenGenerator,
ShardingRuleAware {
    private ShardingRule shardingRule;

    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return true;
    }

    public Collection<TableToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<TableToken> result = new LinkedList<TableToken>();
        for (SQLSegment each : sqlStatementContext.getSqlStatement().getAllSQLSegments()) {
            Optional<TableToken> tableToken;
            if (each instanceof SelectItemsSegment) {
                result.addAll(this.generateSQLTokens(sqlStatementContext, (SelectItemsSegment)each));
                continue;
            }
            if (each instanceof ColumnSegment) {
                tableToken = this.generateSQLToken(sqlStatementContext, (OwnerAvailable<TableSegment>)((ColumnSegment)each));
                if (!tableToken.isPresent()) continue;
                result.add((TableToken)tableToken.get());
                continue;
            }
            if (!(each instanceof TableAvailable) || !(tableToken = this.generateSQLToken(sqlStatementContext.getSqlStatement(), (TableAvailable)each)).isPresent()) continue;
            result.add((TableToken)tableToken.get());
        }
        return result;
    }

    private Collection<TableToken> generateSQLTokens(SQLStatementContext sqlStatementContext, SelectItemsSegment selectItemsSegment) {
        LinkedList<TableToken> result = new LinkedList<TableToken>();
        for (SelectItemSegment each : selectItemsSegment.getSelectItems()) {
            Optional<TableToken> tableToken;
            if (!(each instanceof ShorthandSelectItemSegment) || !(tableToken = this.generateSQLToken(sqlStatementContext, (OwnerAvailable<TableSegment>)((ShorthandSelectItemSegment)each))).isPresent()) continue;
            result.add((TableToken)tableToken.get());
        }
        return result;
    }

    private Optional<TableToken> generateSQLToken(SQLStatementContext sqlStatementContext, OwnerAvailable<TableSegment> segment) {
        Optional owner = segment.getOwner();
        return owner.isPresent() && this.isToGenerateTableToken(sqlStatementContext, (TableSegment)owner.get()) ? Optional.of((Object)new TableToken(((TableSegment)owner.get()).getStartIndex(), ((TableSegment)owner.get()).getStopIndex(), ((TableSegment)owner.get()).getTableName(), ((TableSegment)owner.get()).getQuoteCharacter())) : Optional.absent();
    }

    private Optional<TableToken> generateSQLToken(SQLStatement sqlStatement, TableAvailable segment) {
        return this.isToGenerateTableToken(sqlStatement, segment) ? Optional.of((Object)new TableToken(segment.getStartIndex(), segment.getStopIndex(), segment.getTableName(), segment.getTableQuoteCharacter())) : Optional.absent();
    }

    private boolean isToGenerateTableToken(SQLStatementContext sqlStatementContext, TableSegment tableSegment) {
        Optional table = sqlStatementContext.getTablesContext().find(tableSegment.getTableName());
        return table.isPresent() && !((Table)table.get()).getAlias().isPresent() && this.shardingRule.findTableRule(((Table)table.get()).getName()).isPresent();
    }

    private boolean isToGenerateTableToken(SQLStatement sqlStatement, TableAvailable segment) {
        return this.shardingRule.findTableRule(segment.getTableName()).isPresent() || !(sqlStatement instanceof SelectStatement);
    }

    @Override
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

