/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.core.parse.sql.segment.dml.pagination.NumberLiteralPaginationValueSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.core.preprocessor.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.SelectSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.RowCountToken;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.OptionalSQLTokenGenerator;

public final class RowCountTokenGenerator
implements OptionalSQLTokenGenerator,
IgnoreForSingleRoute {
    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectSQLStatementContext && ((SelectSQLStatementContext)sqlStatementContext).getPaginationContext().getRowCountSegment().isPresent() && ((SelectSQLStatementContext)sqlStatementContext).getPaginationContext().getRowCountSegment().get() instanceof NumberLiteralPaginationValueSegment;
    }

    @Override
    public RowCountToken generateSQLToken(SQLStatementContext sqlStatementContext) {
        PaginationContext pagination = ((SelectSQLStatementContext)sqlStatementContext).getPaginationContext();
        Preconditions.checkState((boolean)pagination.getRowCountSegment().isPresent());
        return new RowCountToken(((PaginationValueSegment)pagination.getRowCountSegment().get()).getStartIndex(), ((PaginationValueSegment)pagination.getRowCountSegment().get()).getStopIndex(), pagination.getRevisedRowCount((SelectSQLStatementContext)sqlStatementContext));
    }
}

