/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.preprocessor.segment.select.projection.Projection;
import org.apache.shardingsphere.core.preprocessor.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.core.preprocessor.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.core.preprocessor.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.SelectSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.ProjectionsToken;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.OptionalSQLTokenGenerator;

public final class ProjectionsTokenGenerator
implements OptionalSQLTokenGenerator,
IgnoreForSingleRoute {
    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectSQLStatementContext && !this.getDerivedProjectionTexts((SelectSQLStatementContext)sqlStatementContext).isEmpty();
    }

    @Override
    public ProjectionsToken generateSQLToken(SQLStatementContext sqlStatementContext) {
        Collection<String> derivedProjectionTexts = this.getDerivedProjectionTexts((SelectSQLStatementContext)sqlStatementContext);
        return new ProjectionsToken(((SelectSQLStatementContext)sqlStatementContext).getProjectionsContext().getStopIndex() + 1 + " ".length(), derivedProjectionTexts);
    }

    private Collection<String> getDerivedProjectionTexts(SelectSQLStatementContext selectSQLStatementContext) {
        LinkedList<String> result = new LinkedList<String>();
        for (Projection each : selectSQLStatementContext.getProjectionsContext().getProjections()) {
            if (each instanceof AggregationProjection && !((AggregationProjection)each).getDerivedAggregationProjections().isEmpty()) {
                result.addAll(Lists.transform((List)((AggregationProjection)each).getDerivedAggregationProjections(), (Function)new Function<AggregationProjection, String>(){

                    public String apply(AggregationProjection input) {
                        return ProjectionsTokenGenerator.this.getDerivedProjectionText((Projection)input);
                    }
                }));
                continue;
            }
            if (!(each instanceof DerivedProjection)) continue;
            result.add(this.getDerivedProjectionText(each));
        }
        return result;
    }

    private String getDerivedProjectionText(Projection projection) {
        Preconditions.checkState((boolean)projection.getAlias().isPresent());
        if (projection instanceof AggregationDistinctProjection) {
            return ((AggregationDistinctProjection)projection).getDistinctInnerExpression() + " AS " + (String)projection.getAlias().get() + " ";
        }
        return projection.getExpression() + " AS " + (String)projection.getAlias().get() + " ";
    }
}

