/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl;

import org.apache.shardingsphere.core.parse.core.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.sql.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.core.preprocessor.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.SelectSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.OrderByToken;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.OptionalSQLTokenGenerator;

public final class OrderByTokenGenerator
implements OptionalSQLTokenGenerator,
IgnoreForSingleRoute {
    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectSQLStatementContext && ((SelectSQLStatementContext)sqlStatementContext).getOrderByContext().isGenerated();
    }

    @Override
    public OrderByToken generateSQLToken(SQLStatementContext sqlStatementContext) {
        OrderByToken result = new OrderByToken(((SelectSQLStatementContext)sqlStatementContext).getGroupByContext().getLastIndex() + 1);
        for (OrderByItem each : ((SelectSQLStatementContext)sqlStatementContext).getOrderByContext().getItems()) {
            String columnLabel;
            if (each.getSegment() instanceof ColumnOrderByItemSegment) {
                ColumnOrderByItemSegment columnOrderByItemSegment = (ColumnOrderByItemSegment)each.getSegment();
                QuoteCharacter quoteCharacter = columnOrderByItemSegment.getColumn().getQuoteCharacter();
                columnLabel = quoteCharacter.getStartDelimiter() + columnOrderByItemSegment.getText() + quoteCharacter.getEndDelimiter();
            } else {
                columnLabel = each.getSegment() instanceof ExpressionOrderByItemSegment ? ((ExpressionOrderByItemSegment)each.getSegment()).getText() : String.valueOf(each.getIndex());
            }
            result.getColumnLabels().add(columnLabel);
            result.getOrderDirections().add(each.getSegment().getOrderDirection());
        }
        return result;
    }
}

