/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.core.parse.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.core.parse.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.preprocessor.segment.insert.InsertValueContext;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.aware.SQLRouteResultAware;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.router.sharding.condition.ShardingCondition;
import org.apache.shardingsphere.core.rule.DataNode;

public final class InsertValuesTokenGenerator
implements OptionalSQLTokenGenerator,
SQLRouteResultAware {
    private SQLRouteResult sqlRouteResult;

    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof InsertStatement && !sqlStatementContext.getSqlStatement().findSQLSegments(InsertValuesSegment.class).isEmpty();
    }

    @Override
    public InsertValuesToken generateSQLToken(SQLStatementContext sqlStatementContext) {
        Collection insertValuesSegments = sqlStatementContext.getSqlStatement().findSQLSegments(InsertValuesSegment.class);
        InsertValuesToken result = new InsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        Iterator shardingConditionIterator = null == this.sqlRouteResult || this.sqlRouteResult.getShardingConditions().getConditions().isEmpty() ? null : this.sqlRouteResult.getShardingConditions().getConditions().iterator();
        for (InsertValueContext each : ((InsertSQLStatementContext)sqlStatementContext).getInsertValueContexts()) {
            List expressionSegments = each.getValueExpressions();
            List<DataNode> dataNodes = null == shardingConditionIterator ? Collections.emptyList() : ((ShardingCondition)shardingConditionIterator.next()).getDataNodes();
            result.getInsertValueTokens().add(new InsertValuesToken.InsertValueToken(expressionSegments, dataNodes));
        }
        return result;
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = result > each.getStartIndex() ? each.getStartIndex() : result;
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = result < each.getStopIndex() ? each.getStopIndex() : result;
        }
        return result;
    }

    @Override
    public void setSqlRouteResult(SQLRouteResult sqlRouteResult) {
        this.sqlRouteResult = sqlRouteResult;
    }
}

