/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.preprocessor.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.core.preprocessor.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.SelectSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.pojo.AggregationDistinctToken;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.CollectionSQLTokenGenerator;

public final class AggregationDistinctTokenGenerator
implements CollectionSQLTokenGenerator,
IgnoreForSingleRoute {
    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectSQLStatementContext;
    }

    public Collection<AggregationDistinctToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<AggregationDistinctToken> result = new LinkedList<AggregationDistinctToken>();
        for (AggregationDistinctProjection each : ((SelectSQLStatementContext)sqlStatementContext).getProjectionsContext().getAggregationDistinctProjections()) {
            result.add(this.generateSQLToken(each));
        }
        return result;
    }

    private AggregationDistinctToken generateSQLToken(AggregationDistinctProjection projection) {
        Preconditions.checkArgument((boolean)projection.getAlias().isPresent());
        String derivedAlias = DerivedColumn.isDerivedColumnName((String)((String)projection.getAlias().get())) ? (String)projection.getAlias().get() : null;
        return new AggregationDistinctToken(projection.getStartIndex(), projection.getStopIndex(), projection.getDistinctInnerExpression(), derivedAlias);
    }
}

