/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.token;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.rewrite.feature.sharding.aware.SQLRouteResultAware;
import org.apache.shardingsphere.core.rewrite.feature.sharding.aware.ShardingRuleAware;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.AggregationDistinctTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.DistinctProjectionPrefixTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.IndexTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.InsertValuesTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.OffsetTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.OrderByTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.ProjectionsTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.RowCountTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.TableTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen.GeneratedKeyAssignmentTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen.GeneratedKeyForUseDefaultInsertColumnsTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen.GeneratedKeyInsertColumnTokenGenerator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.generator.impl.keygen.GeneratedKeyInsertValuesTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.builder.SQLTokenGeneratorBuilder;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class ShardingTokenGenerateBuilder
implements SQLTokenGeneratorBuilder {
    private final ShardingRule shardingRule;
    private final SQLRouteResult sqlRouteResult;

    @Override
    public Collection<SQLTokenGenerator> getSQLTokenGenerators() {
        Collection<SQLTokenGenerator> result = this.buildSQLTokenGenerators();
        for (SQLTokenGenerator each : result) {
            if (each instanceof ShardingRuleAware) {
                ((ShardingRuleAware)((Object)each)).setShardingRule(this.shardingRule);
            }
            if (!(each instanceof SQLRouteResultAware)) continue;
            ((SQLRouteResultAware)((Object)each)).setSqlRouteResult(this.sqlRouteResult);
        }
        return result;
    }

    private Collection<SQLTokenGenerator> buildSQLTokenGenerators() {
        LinkedList<SQLTokenGenerator> result = new LinkedList<SQLTokenGenerator>();
        this.addSQLTokenGenerator(result, new TableTokenGenerator());
        this.addSQLTokenGenerator(result, new DistinctProjectionPrefixTokenGenerator());
        this.addSQLTokenGenerator(result, new ProjectionsTokenGenerator());
        this.addSQLTokenGenerator(result, new OrderByTokenGenerator());
        this.addSQLTokenGenerator(result, new AggregationDistinctTokenGenerator());
        this.addSQLTokenGenerator(result, new IndexTokenGenerator());
        this.addSQLTokenGenerator(result, new OffsetTokenGenerator());
        this.addSQLTokenGenerator(result, new RowCountTokenGenerator());
        this.addSQLTokenGenerator(result, new GeneratedKeyInsertColumnTokenGenerator());
        this.addSQLTokenGenerator(result, new GeneratedKeyForUseDefaultInsertColumnsTokenGenerator());
        this.addSQLTokenGenerator(result, new GeneratedKeyAssignmentTokenGenerator());
        this.addSQLTokenGenerator(result, new InsertValuesTokenGenerator());
        this.addSQLTokenGenerator(result, new GeneratedKeyInsertValuesTokenGenerator());
        return result;
    }

    private void addSQLTokenGenerator(Collection<SQLTokenGenerator> sqlTokenGenerators, SQLTokenGenerator toBeAddedSQLTokenGenerator) {
        if (toBeAddedSQLTokenGenerator instanceof IgnoreForSingleRoute && this.sqlRouteResult.getRoutingResult().isSingleRouting()) {
            return;
        }
        sqlTokenGenerators.add(toBeAddedSQLTokenGenerator);
    }

    @ConstructorProperties(value={"shardingRule", "sqlRouteResult"})
    public ShardingTokenGenerateBuilder(ShardingRule shardingRule, SQLRouteResult sqlRouteResult) {
        this.shardingRule = shardingRule;
        this.sqlRouteResult = sqlRouteResult;
    }
}

