/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.parameter.impl;

import com.google.common.base.Optional;
import java.util.List;
import org.apache.shardingsphere.core.preprocessor.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.SelectSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.aware.SQLRouteResultAware;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.core.route.SQLRouteResult;

public final class ShardingPaginationParameterRewriter
implements ParameterRewriter,
SQLRouteResultAware {
    private SQLRouteResult sqlRouteResult;

    @Override
    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return this.sqlRouteResult.getSqlStatementContext() instanceof SelectSQLStatementContext && ((SelectSQLStatementContext)this.sqlRouteResult.getSqlStatementContext()).getPaginationContext().isHasPagination() && !this.sqlRouteResult.getRoutingResult().isSingleRouting();
    }

    @Override
    public void rewrite(ParameterBuilder parameterBuilder, SQLStatementContext sqlStatementContext, List<Object> parameters) {
        Optional rowCountParameterIndex;
        PaginationContext pagination = ((SelectSQLStatementContext)this.sqlRouteResult.getSqlStatementContext()).getPaginationContext();
        Optional offsetParameterIndex = pagination.getOffsetParameterIndex();
        if (offsetParameterIndex.isPresent()) {
            this.rewriteOffset(pagination, (Integer)offsetParameterIndex.get(), (StandardParameterBuilder)parameterBuilder);
        }
        if ((rowCountParameterIndex = pagination.getRowCountParameterIndex()).isPresent()) {
            this.rewriteRowCount(pagination, (Integer)rowCountParameterIndex.get(), (StandardParameterBuilder)parameterBuilder);
        }
    }

    private void rewriteOffset(PaginationContext pagination, int offsetParameterIndex, StandardParameterBuilder parameterBuilder) {
        parameterBuilder.addReplacedParameters(offsetParameterIndex, pagination.getRevisedOffset());
    }

    private void rewriteRowCount(PaginationContext pagination, int rowCountParameterIndex, StandardParameterBuilder parameterBuilder) {
        parameterBuilder.addReplacedParameters(rowCountParameterIndex, pagination.getRevisedRowCount((SelectSQLStatementContext)this.sqlRouteResult.getSqlStatementContext()));
    }

    @Override
    public void setSqlRouteResult(SQLRouteResult sqlRouteResult) {
        this.sqlRouteResult = sqlRouteResult;
    }
}

