/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.parameter.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.core.preprocessor.segment.insert.InsertValueContext;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.sharding.aware.SQLRouteResultAware;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.router.sharding.keygen.GeneratedKey;

public final class ShardingGeneratedKeyInsertValueParameterRewriter
implements ParameterRewriter,
SQLRouteResultAware {
    private SQLRouteResult sqlRouteResult;

    @Override
    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertSQLStatementContext && this.sqlRouteResult.getGeneratedKey().isPresent() && ((GeneratedKey)this.sqlRouteResult.getGeneratedKey().get()).isGenerated();
    }

    @Override
    public void rewrite(ParameterBuilder parameterBuilder, SQLStatementContext sqlStatementContext, List<Object> parameters) {
        Preconditions.checkState((boolean)this.sqlRouteResult.getGeneratedKey().isPresent());
        ((GroupedParameterBuilder)parameterBuilder).setDerivedColumnName(((GeneratedKey)this.sqlRouteResult.getGeneratedKey().get()).getColumnName());
        Iterator generatedValues = ((GeneratedKey)this.sqlRouteResult.getGeneratedKey().get()).getGeneratedValues().descendingIterator();
        int count = 0;
        int parametersCount = 0;
        for (List each : ((InsertSQLStatementContext)sqlStatementContext).getGroupedParameters()) {
            parametersCount += ((InsertValueContext)((InsertSQLStatementContext)sqlStatementContext).getInsertValueContexts().get(count)).getParametersCount();
            Comparable generatedValue = (Comparable)generatedValues.next();
            if (!each.isEmpty()) {
                ((GroupedParameterBuilder)parameterBuilder).getParameterBuilders().get(count).addAddedParameters(parametersCount, Lists.newArrayList((Object[])new Object[]{generatedValue}));
            }
            ++count;
        }
    }

    @Override
    public void setSqlRouteResult(SQLRouteResult sqlRouteResult) {
        this.sqlRouteResult = sqlRouteResult;
    }
}

