/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.parameter;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.rewrite.feature.sharding.aware.SQLRouteResultAware;
import org.apache.shardingsphere.core.rewrite.feature.sharding.aware.ShardingRuleAware;
import org.apache.shardingsphere.core.rewrite.feature.sharding.parameter.impl.ShardingGeneratedKeyInsertValueParameterRewriter;
import org.apache.shardingsphere.core.rewrite.feature.sharding.parameter.impl.ShardingPaginationParameterRewriter;
import org.apache.shardingsphere.core.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.core.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.TableMetasAware;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class ShardingParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final ShardingRule shardingRule;
    private final SQLRouteResult sqlRouteResult;

    @Override
    public Collection<ParameterRewriter> getParameterRewriters(TableMetas tableMetas) {
        Collection<ParameterRewriter> result = ShardingParameterRewriterBuilder.getParameterRewriters();
        for (ParameterRewriter each : result) {
            this.setUpParameterRewriters(each, tableMetas);
        }
        return result;
    }

    private static Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        result.add(new ShardingGeneratedKeyInsertValueParameterRewriter());
        result.add(new ShardingPaginationParameterRewriter());
        return result;
    }

    private void setUpParameterRewriters(ParameterRewriter parameterRewriter, TableMetas tableMetas) {
        if (parameterRewriter instanceof TableMetasAware) {
            ((TableMetasAware)((Object)parameterRewriter)).setTableMetas(tableMetas);
        }
        if (parameterRewriter instanceof ShardingRuleAware) {
            ((ShardingRuleAware)((Object)parameterRewriter)).setShardingRule(this.shardingRule);
        }
        if (parameterRewriter instanceof SQLRouteResultAware) {
            ((SQLRouteResultAware)((Object)parameterRewriter)).setSqlRouteResult(this.sqlRouteResult);
        }
    }

    @ConstructorProperties(value={"shardingRule", "sqlRouteResult"})
    public ShardingParameterRewriterBuilder(ShardingRule shardingRule, SQLRouteResult sqlRouteResult) {
        this.shardingRule = shardingRule;
        this.sqlRouteResult = sqlRouteResult;
    }
}

