/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.engine;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.core.rewrite.engine.SQLRewriteEngine;
import org.apache.shardingsphere.core.rewrite.engine.SQLRewriteResult;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.core.route.router.sharding.condition.ShardingCondition;
import org.apache.shardingsphere.core.route.router.sharding.condition.ShardingConditions;
import org.apache.shardingsphere.core.route.type.RoutingUnit;
import org.apache.shardingsphere.core.rule.DataNode;

public final class ShardingSQLRewriteEngine
implements SQLRewriteEngine {
    private final ShardingConditions shardingConditions;
    private final RoutingUnit routingUnit;
    private final Map<String, String> logicAndActualTables;

    @Override
    public SQLRewriteResult rewrite(SQLRewriteContext sqlRewriteContext) {
        return new SQLRewriteResult(sqlRewriteContext.getSQLBuilder().toSQL(this.routingUnit, this.logicAndActualTables), this.getParameters(sqlRewriteContext.getParameterBuilder()));
    }

    private List<Object> getParameters(ParameterBuilder parameterBuilder) {
        if (parameterBuilder instanceof StandardParameterBuilder || this.shardingConditions.getConditions().isEmpty()) {
            return parameterBuilder.getParameters();
        }
        if (parameterBuilder.getParameters().isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Object> result = new LinkedList<Object>();
        int count = 0;
        for (ShardingCondition each : this.shardingConditions.getConditions()) {
            if (this.isInSameDataNode(each)) {
                result.addAll(((GroupedParameterBuilder)parameterBuilder).getParameters(count));
            }
            ++count;
        }
        return result;
    }

    private boolean isInSameDataNode(ShardingCondition shardingCondition) {
        if (shardingCondition.getDataNodes().isEmpty()) {
            return true;
        }
        for (DataNode each : shardingCondition.getDataNodes()) {
            if (!this.routingUnit.getTableUnit(each.getDataSourceName(), each.getTableName()).isPresent()) continue;
            return true;
        }
        return false;
    }

    @ConstructorProperties(value={"shardingConditions", "routingUnit", "logicAndActualTables"})
    public ShardingSQLRewriteEngine(ShardingConditions shardingConditions, RoutingUnit routingUnit, Map<String, String> logicAndActualTables) {
        this.shardingConditions = shardingConditions;
        this.routingUnit = routingUnit;
        this.logicAndActualTables = logicAndActualTables;
    }
}

