/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.sharding.context;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.core.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.core.rewrite.feature.sharding.parameter.ShardingParameterRewriterBuilder;
import org.apache.shardingsphere.core.rewrite.feature.sharding.token.ShardingTokenGenerateBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class ShardingSQLRewriteContextDecorator
implements SQLRewriteContextDecorator {
    private final ShardingRule shardingRule;
    private final SQLRouteResult sqlRouteResult;

    @Override
    public void decorate(SQLRewriteContext sqlRewriteContext) {
        for (ParameterRewriter each : new ShardingParameterRewriterBuilder(this.shardingRule, this.sqlRouteResult).getParameterRewriters(sqlRewriteContext.getTableMetas())) {
            if (sqlRewriteContext.getParameters().isEmpty() || !each.isNeedRewrite(sqlRewriteContext.getSqlStatementContext())) continue;
            each.rewrite(sqlRewriteContext.getParameterBuilder(), sqlRewriteContext.getSqlStatementContext(), sqlRewriteContext.getParameters());
        }
        sqlRewriteContext.addSQLTokenGenerators(new ShardingTokenGenerateBuilder(this.shardingRule, this.sqlRouteResult).getSQLTokenGenerators());
    }

    @ConstructorProperties(value={"shardingRule", "sqlRouteResult"})
    public ShardingSQLRewriteContextDecorator(ShardingRule shardingRule, SQLRouteResult sqlRouteResult) {
        this.shardingRule = shardingRule;
        this.sqlRouteResult = sqlRouteResult;
    }
}

