/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.shardingsphere.core.parse.sql.segment.dml.item.ColumnSelectItemSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.item.SelectItemsSegment;
import org.apache.shardingsphere.core.parse.sql.segment.generic.TableSegment;
import org.apache.shardingsphere.core.parse.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.core.strategy.encrypt.EncryptTable;

public final class EncryptProjectionTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator,
QueryWithCipherColumnAware {
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext.getSqlStatement() instanceof SelectStatement) || sqlStatementContext.getTablesContext().isEmpty()) {
            return false;
        }
        Optional selectItemsSegment = sqlStatementContext.getSqlStatement().findSQLSegment(SelectItemsSegment.class);
        return selectItemsSegment.isPresent() && !((SelectItemsSegment)selectItemsSegment.get()).getSelectItems().isEmpty();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        Optional selectItemsSegment = sqlStatementContext.getSqlStatement().findSQLSegment(SelectItemsSegment.class);
        Preconditions.checkState((boolean)selectItemsSegment.isPresent());
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        Optional encryptTable = this.getEncryptRule().findEncryptTable(tableName);
        if (!encryptTable.isPresent()) {
            return Collections.emptyList();
        }
        for (SelectItemSegment each : ((SelectItemsSegment)selectItemsSegment.get()).getSelectItems()) {
            if (!this.isEncryptLogicColumn(each, (EncryptTable)encryptTable.get())) continue;
            result.add(this.generateSQLToken((ColumnSelectItemSegment)each, tableName));
        }
        return result;
    }

    private boolean isEncryptLogicColumn(SelectItemSegment selectItemSegment, EncryptTable encryptTable) {
        return selectItemSegment instanceof ColumnSelectItemSegment && encryptTable.getLogicColumns().contains(((ColumnSelectItemSegment)selectItemSegment).getName());
    }

    private SubstitutableColumnNameToken generateSQLToken(ColumnSelectItemSegment segment, String tableName) {
        Optional plainColumn = this.getEncryptRule().findPlainColumn(tableName, segment.getName());
        String columnName = plainColumn.isPresent() && !this.queryWithCipherColumn ? (String)plainColumn.get() : this.getEncryptRule().getCipherColumn(tableName, segment.getName());
        return segment.getOwner().isPresent() ? new SubstitutableColumnNameToken(((TableSegment)segment.getOwner().get()).getStopIndex() + 2, segment.getStopIndex(), columnName) : new SubstitutableColumnNameToken(segment.getStartIndex(), segment.getStopIndex(), columnName);
    }

    @Override
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

