/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.core.parse.sql.segment.generic.TableSegment;
import org.apache.shardingsphere.core.parse.sql.statement.generic.WhereSegmentAvailable;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.TableMetasAware;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.core.strategy.encrypt.EncryptTable;

public final class EncryptPredicateColumnTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator,
TableMetasAware,
QueryWithCipherColumnAware {
    private TableMetas tableMetas;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof WhereSegmentAvailable && ((WhereSegmentAvailable)sqlStatementContext.getSqlStatement()).getWhere().isPresent();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Preconditions.checkState((boolean)((WhereSegmentAvailable)sqlStatementContext.getSqlStatement()).getWhere().isPresent());
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (AndPredicate each : ((WhereSegment)((WhereSegmentAvailable)sqlStatementContext.getSqlStatement()).getWhere().get()).getAndPredicates()) {
            result.addAll(this.generateSQLTokens(sqlStatementContext, each));
        }
        return result;
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext, AndPredicate andPredicate) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (PredicateSegment each : andPredicate.getPredicates()) {
            Optional plainColumn;
            Optional<EncryptTable> encryptTable = this.findEncryptTable(sqlStatementContext, each);
            if (!encryptTable.isPresent() || !((EncryptTable)encryptTable.get()).findShardingEncryptor(each.getColumn().getName()).isPresent()) continue;
            int startIndex = each.getColumn().getOwner().isPresent() ? ((TableSegment)each.getColumn().getOwner().get()).getStopIndex() + 2 : each.getColumn().getStartIndex();
            int stopIndex = each.getColumn().getStopIndex();
            if (!this.queryWithCipherColumn && (plainColumn = ((EncryptTable)encryptTable.get()).findPlainColumn(each.getColumn().getName())).isPresent()) {
                result.add(new SubstitutableColumnNameToken(startIndex, stopIndex, (String)plainColumn.get()));
                continue;
            }
            Optional assistedQueryColumn = ((EncryptTable)encryptTable.get()).findAssistedQueryColumn(each.getColumn().getName());
            SubstitutableColumnNameToken encryptColumnNameToken = assistedQueryColumn.isPresent() ? new SubstitutableColumnNameToken(startIndex, stopIndex, (String)assistedQueryColumn.get()) : new SubstitutableColumnNameToken(startIndex, stopIndex, ((EncryptTable)encryptTable.get()).getCipherColumn(each.getColumn().getName()));
            result.add(encryptColumnNameToken);
        }
        return result;
    }

    private Optional<EncryptTable> findEncryptTable(SQLStatementContext sqlStatementContext, PredicateSegment segment) {
        Optional tableName = sqlStatementContext.getTablesContext().findTableName(segment.getColumn(), this.tableMetas);
        return tableName.isPresent() ? this.getEncryptRule().findEncryptTable((String)tableName.get()) : Optional.absent();
    }

    @Override
    public void setTableMetas(TableMetas tableMetas) {
        this.tableMetas = tableMetas;
    }

    @Override
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

