/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator.impl;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.core.parse.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.core.preprocessor.segment.insert.InsertValueContext;
import org.apache.shardingsphere.core.preprocessor.segment.insert.expression.DerivedLiteralExpressionSegment;
import org.apache.shardingsphere.core.preprocessor.segment.insert.expression.DerivedParameterMarkerExpressionSegment;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic.UseDefaultInsertColumnsToken;
import org.apache.shardingsphere.spi.encrypt.ShardingEncryptor;
import org.apache.shardingsphere.spi.encrypt.ShardingQueryAssistedEncryptor;

public final class EncryptInsertValuesTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements OptionalSQLTokenGenerator,
PreviousSQLTokensAware {
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertSQLStatementContext && !sqlStatementContext.getSqlStatement().findSQLSegments(InsertValuesSegment.class).isEmpty();
    }

    @Override
    public InsertValuesToken generateSQLToken(SQLStatementContext sqlStatementContext) {
        Optional<SQLToken> insertValuesToken = this.findPreviousSQLToken(InsertValuesToken.class);
        if (insertValuesToken.isPresent()) {
            this.processPreviousSQLToken((InsertSQLStatementContext)sqlStatementContext, (InsertValuesToken)insertValuesToken.get());
            return (InsertValuesToken)insertValuesToken.get();
        }
        return this.generateNewSQLToken((InsertSQLStatementContext)sqlStatementContext);
    }

    private Optional<SQLToken> findPreviousSQLToken(Class<?> sqlToken) {
        for (SQLToken each : this.previousSQLTokens) {
            if (!each.getClass().equals(sqlToken)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private void processPreviousSQLToken(InsertSQLStatementContext sqlStatementContext, InsertValuesToken insertValuesToken) {
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        int count = 0;
        for (InsertValueContext each : sqlStatementContext.getInsertValueContexts()) {
            this.encryptToken(insertValuesToken.getInsertValueTokens().get(count), tableName, sqlStatementContext, each);
            ++count;
        }
    }

    private InsertValuesToken generateNewSQLToken(InsertSQLStatementContext sqlStatementContext) {
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        Collection insertValuesSegments = sqlStatementContext.getSqlStatement().findSQLSegments(InsertValuesSegment.class);
        InsertValuesToken result = new InsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        for (InsertValueContext each : sqlStatementContext.getInsertValueContexts()) {
            InsertValuesToken.InsertValueToken insertValueToken = new InsertValuesToken.InsertValueToken(each.getValueExpressions(), Collections.emptyList());
            this.encryptToken(insertValueToken, tableName, sqlStatementContext, each);
            result.getInsertValueTokens().add(insertValueToken);
        }
        return result;
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.min(result, each.getStartIndex());
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.max(result, each.getStopIndex());
        }
        return result;
    }

    private void encryptToken(InsertValuesToken.InsertValueToken insertValueToken, String tableName, InsertSQLStatementContext sqlStatementContext, InsertValueContext insertValueContext) {
        Optional<SQLToken> useDefaultInsertColumnsToken = this.findPreviousSQLToken(UseDefaultInsertColumnsToken.class);
        Iterator descendingColumnNames = sqlStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            Optional encryptor = this.getEncryptRule().findShardingEncryptor(tableName, columnName);
            if (!encryptor.isPresent()) continue;
            int columnIndex = useDefaultInsertColumnsToken.isPresent() ? ((UseDefaultInsertColumnsToken)useDefaultInsertColumnsToken.get()).getColumns().indexOf(columnName) : sqlStatementContext.getColumnNames().indexOf(columnName);
            Object originalValue = insertValueContext.getValue(columnIndex);
            this.addPlainColumn(insertValueToken, columnIndex, tableName, columnName, insertValueContext, originalValue);
            this.addAssistedQueryColumn(insertValueToken, (ShardingEncryptor)encryptor.get(), columnIndex, tableName, columnName, insertValueContext, originalValue);
            this.setCipherColumn(insertValueToken, (ShardingEncryptor)encryptor.get(), columnIndex, (ExpressionSegment)insertValueContext.getValueExpressions().get(columnIndex), originalValue);
        }
    }

    private void addPlainColumn(InsertValuesToken.InsertValueToken insertValueToken, int columnIndex, String tableName, String columnName, InsertValueContext insertValueContext, Object originalValue) {
        if (this.getEncryptRule().findPlainColumn(tableName, columnName).isPresent()) {
            DerivedLiteralExpressionSegment derivedExpressionSegment = insertValueContext.getParameters().isEmpty() ? new DerivedLiteralExpressionSegment(originalValue) : new DerivedParameterMarkerExpressionSegment(this.getParameterIndexCount(insertValueToken));
            insertValueToken.getValues().add(columnIndex + 1, (ExpressionSegment)derivedExpressionSegment);
        }
    }

    private void addAssistedQueryColumn(InsertValuesToken.InsertValueToken insertValueToken, ShardingEncryptor encryptor, int columnIndex, String tableName, String columnName, InsertValueContext insertValueContext, Object originalValue) {
        if (this.getEncryptRule().findAssistedQueryColumn(tableName, columnName).isPresent()) {
            DerivedLiteralExpressionSegment derivedExpressionSegment = insertValueContext.getParameters().isEmpty() ? new DerivedLiteralExpressionSegment((Object)((ShardingQueryAssistedEncryptor)encryptor).queryAssistedEncrypt(null == originalValue ? null : originalValue.toString())) : new DerivedParameterMarkerExpressionSegment(this.getParameterIndexCount(insertValueToken));
            insertValueToken.getValues().add(columnIndex + 1, (ExpressionSegment)derivedExpressionSegment);
        }
    }

    private int getParameterIndexCount(InsertValuesToken.InsertValueToken insertValueToken) {
        int result = 0;
        for (ExpressionSegment each : insertValueToken.getValues()) {
            if (!(each instanceof ParameterMarkerExpressionSegment)) continue;
            ++result;
        }
        return result;
    }

    private void setCipherColumn(InsertValuesToken.InsertValueToken insertValueToken, ShardingEncryptor encryptor, int columnIndex, ExpressionSegment valueExpression, Object originalValue) {
        if (valueExpression instanceof LiteralExpressionSegment) {
            insertValueToken.getValues().set(columnIndex, (ExpressionSegment)new LiteralExpressionSegment(valueExpression.getStartIndex(), valueExpression.getStopIndex(), (Object)encryptor.encrypt(originalValue)));
        }
    }

    @Override
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

