/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.parse.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.core.parse.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.generic.InsertColumnsToken;
import org.apache.shardingsphere.core.strategy.encrypt.EncryptTable;

public final class AssistQueryAndPlainInsertColumnsTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator {
    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertSQLStatementContext && sqlStatementContext.getSqlStatement().findSQLSegment(InsertColumnsSegment.class).isPresent() && !((InsertStatement)sqlStatementContext.getSqlStatement()).useDefaultColumns();
    }

    public Collection<InsertColumnsToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<InsertColumnsToken> result = new LinkedList<InsertColumnsToken>();
        Optional encryptTable = this.getEncryptRule().findEncryptTable(sqlStatementContext.getTablesContext().getSingleTableName());
        Preconditions.checkState((boolean)encryptTable.isPresent());
        for (ColumnSegment each : ((InsertStatement)sqlStatementContext.getSqlStatement()).getColumns()) {
            List<String> columns = this.getColumns((EncryptTable)encryptTable.get(), each);
            if (columns.isEmpty()) continue;
            result.add(new InsertColumnsToken(each.getStopIndex() + 1, columns));
        }
        return result;
    }

    private List<String> getColumns(EncryptTable encryptTable, ColumnSegment columnSegment) {
        Optional plainColumn;
        LinkedList<String> result = new LinkedList<String>();
        Optional assistedQueryColumn = encryptTable.findAssistedQueryColumn(columnSegment.getName());
        if (assistedQueryColumn.isPresent()) {
            result.add((String)assistedQueryColumn.get());
        }
        if ((plainColumn = encryptTable.findPlainColumn(columnSegment.getName())).isPresent()) {
            result.add((String)plainColumn.get());
        }
        return result;
    }
}

