/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.token.generator;

import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.aware.EncryptRuleAware;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.core.rule.EncryptRule;

public abstract class BaseEncryptSQLTokenGenerator
implements SQLTokenGenerator,
EncryptRuleAware {
    private EncryptRule encryptRule;

    @Override
    public final boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return this.isGenerateSQLTokenForEncrypt(sqlStatementContext) && this.isNeedEncrypt(sqlStatementContext);
    }

    protected abstract boolean isGenerateSQLTokenForEncrypt(SQLStatementContext var1);

    private boolean isNeedEncrypt(SQLStatementContext sqlStatementContext) {
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            if (!this.encryptRule.findEncryptTable(each).isPresent()) continue;
            return true;
        }
        return false;
    }

    public EncryptRule getEncryptRule() {
        return this.encryptRule;
    }

    @Override
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

