/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.impl;

import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.EncryptCondition;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.EncryptConditionEngine;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.EncryptParameterRewriter;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.TableMetasAware;

public final class EncryptPredicateParameterRewriter
extends EncryptParameterRewriter
implements TableMetasAware,
QueryWithCipherColumnAware {
    private TableMetas tableMetas;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isNeedRewriteForEncrypt(SQLStatementContext sqlStatementContext) {
        return true;
    }

    @Override
    public void rewrite(ParameterBuilder parameterBuilder, SQLStatementContext sqlStatementContext, List<Object> parameters) {
        List<EncryptCondition> encryptConditions = new EncryptConditionEngine(this.getEncryptRule(), this.tableMetas).createEncryptConditions(sqlStatementContext);
        if (encryptConditions.isEmpty()) {
            return;
        }
        for (EncryptCondition each : encryptConditions) {
            if (!this.queryWithCipherColumn) continue;
            this.encryptParameters(parameterBuilder, each.getPositionIndexMap(), this.getEncryptedValues(each, each.getValues(parameters)));
        }
    }

    private List<Object> getEncryptedValues(EncryptCondition encryptCondition, List<Object> originalValues) {
        String tableName = encryptCondition.getTableName();
        String columnName = encryptCondition.getColumnName();
        return this.getEncryptRule().findAssistedQueryColumn(tableName, columnName).isPresent() ? this.getEncryptRule().getEncryptAssistedQueryValues(tableName, columnName, originalValues) : this.getEncryptRule().getEncryptValues(tableName, columnName, originalValues);
    }

    private void encryptParameters(ParameterBuilder parameterBuilder, Map<Integer, Integer> positionIndexes, List<Object> encryptValues) {
        if (!positionIndexes.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : positionIndexes.entrySet()) {
                ((StandardParameterBuilder)parameterBuilder).addReplacedParameters(entry.getValue(), encryptValues.get(entry.getKey()));
            }
        }
    }

    @Override
    public void setTableMetas(TableMetas tableMetas) {
        this.tableMetas = tableMetas;
    }

    @Override
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

