/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.parse.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.preprocessor.segment.insert.InsertValueContext;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.EncryptParameterRewriter;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.spi.encrypt.ShardingEncryptor;
import org.apache.shardingsphere.spi.encrypt.ShardingQueryAssistedEncryptor;

public final class EncryptInsertValueParameterRewriter
extends EncryptParameterRewriter {
    @Override
    protected boolean isNeedRewriteForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertSQLStatementContext && !((InsertStatement)sqlStatementContext.getSqlStatement()).getSetAssignment().isPresent();
    }

    @Override
    public void rewrite(ParameterBuilder parameterBuilder, SQLStatementContext sqlStatementContext, List<Object> parameters) {
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        Iterator descendingColumnNames = ((InsertSQLStatementContext)sqlStatementContext).getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            Optional shardingEncryptor = this.getEncryptRule().findShardingEncryptor(tableName, columnName);
            if (!shardingEncryptor.isPresent()) continue;
            this.encryptInsertValues((GroupedParameterBuilder)parameterBuilder, (InsertSQLStatementContext)sqlStatementContext, (ShardingEncryptor)shardingEncryptor.get(), tableName, columnName);
        }
    }

    private void encryptInsertValues(GroupedParameterBuilder parameterBuilder, InsertSQLStatementContext sqlStatementContext, ShardingEncryptor shardingEncryptor, String tableName, String encryptLogicColumnName) {
        int columnIndex = this.getColumnIndex(parameterBuilder, sqlStatementContext, encryptLogicColumnName);
        int count = 0;
        for (List each : sqlStatementContext.getGroupedParameters()) {
            if (!each.isEmpty()) {
                StandardParameterBuilder standardParameterBuilder = parameterBuilder.getParameterBuilders().get(count);
                this.encryptInsertValue(shardingEncryptor, tableName, columnIndex, ((InsertValueContext)sqlStatementContext.getInsertValueContexts().get(count)).getValue(columnIndex), standardParameterBuilder, encryptLogicColumnName);
            }
            ++count;
        }
    }

    private int getColumnIndex(GroupedParameterBuilder parameterBuilder, InsertSQLStatementContext sqlStatementContext, String encryptLogicColumnName) {
        ArrayList columnNames;
        if (parameterBuilder.getDerivedColumnName().isPresent()) {
            columnNames = new ArrayList(sqlStatementContext.getColumnNames());
            columnNames.remove(parameterBuilder.getDerivedColumnName().get());
        } else {
            columnNames = sqlStatementContext.getColumnNames();
        }
        return columnNames.indexOf(encryptLogicColumnName);
    }

    private void encryptInsertValue(ShardingEncryptor shardingEncryptor, String tableName, int columnIndex, Object originalValue, StandardParameterBuilder parameterBuilder, String encryptLogicColumnName) {
        parameterBuilder.addReplacedParameters(columnIndex, shardingEncryptor.encrypt(originalValue));
        LinkedList<Object> addedParameters = new LinkedList<Object>();
        if (shardingEncryptor instanceof ShardingQueryAssistedEncryptor) {
            Optional assistedColumnName = this.getEncryptRule().findAssistedQueryColumn(tableName, encryptLogicColumnName);
            Preconditions.checkArgument((boolean)assistedColumnName.isPresent(), (Object)"Can not find assisted query Column Name");
            addedParameters.add(((ShardingQueryAssistedEncryptor)shardingEncryptor).queryAssistedEncrypt(originalValue.toString()));
        }
        if (this.getEncryptRule().findPlainColumn(tableName, encryptLogicColumnName).isPresent()) {
            addedParameters.add(originalValue);
        }
        if (!addedParameters.isEmpty()) {
            if (!parameterBuilder.getAddedIndexAndParameters().containsKey(columnIndex + 1)) {
                parameterBuilder.getAddedIndexAndParameters().put(columnIndex + 1, new LinkedList());
            }
            parameterBuilder.getAddedIndexAndParameters().get(columnIndex + 1).addAll(addedParameters);
        }
    }
}

