/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.parse.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.assignment.SetAssignmentsSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dml.UpdateStatement;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.EncryptParameterRewriter;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.StandardParameterBuilder;

public final class EncryptAssignmentParameterRewriter
extends EncryptParameterRewriter {
    @Override
    protected boolean isNeedRewriteForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof UpdateStatement || sqlStatementContext instanceof InsertSQLStatementContext && sqlStatementContext.getSqlStatement().findSQLSegment(SetAssignmentsSegment.class).isPresent();
    }

    @Override
    public void rewrite(ParameterBuilder parameterBuilder, SQLStatementContext sqlStatementContext, List<Object> parameters) {
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        for (AssignmentSegment each : this.getSetAssignmentsSegment(sqlStatementContext.getSqlStatement()).getAssignments()) {
            if (!(each.getValue() instanceof ParameterMarkerExpressionSegment) || !this.getEncryptRule().findShardingEncryptor(tableName, each.getColumn().getName()).isPresent()) continue;
            StandardParameterBuilder standardParameterBuilder = parameterBuilder instanceof StandardParameterBuilder ? (StandardParameterBuilder)parameterBuilder : ((GroupedParameterBuilder)parameterBuilder).getParameterBuilders().get(0);
            this.encryptParameters(standardParameterBuilder, tableName, each, parameters);
        }
    }

    private SetAssignmentsSegment getSetAssignmentsSegment(SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            Optional result = ((InsertStatement)sqlStatement).getSetAssignment();
            Preconditions.checkState((boolean)result.isPresent());
            return (SetAssignmentsSegment)result.get();
        }
        return ((UpdateStatement)sqlStatement).getSetAssignment();
    }

    private void encryptParameters(StandardParameterBuilder parameterBuilder, String tableName, AssignmentSegment assignmentSegment, List<Object> parameters) {
        String columnName = assignmentSegment.getColumn().getName();
        int parameterMarkerIndex = ((ParameterMarkerExpressionSegment)assignmentSegment.getValue()).getParameterMarkerIndex();
        Object originalValue = parameters.get(parameterMarkerIndex);
        Object cipherValue = this.getEncryptRule().getEncryptValues(tableName, columnName, Collections.singletonList(originalValue)).iterator().next();
        parameterBuilder.addReplacedParameters(parameterMarkerIndex, cipherValue);
        LinkedList<Object> addedParameters = new LinkedList<Object>();
        if (this.getEncryptRule().findAssistedQueryColumn(tableName, columnName).isPresent()) {
            Object assistedQueryValue = this.getEncryptRule().getEncryptAssistedQueryValues(tableName, columnName, Collections.singletonList(originalValue)).iterator().next();
            addedParameters.add(assistedQueryValue);
        }
        if (this.getEncryptRule().findPlainColumn(tableName, columnName).isPresent()) {
            addedParameters.add(originalValue);
        }
        if (!addedParameters.isEmpty()) {
            parameterBuilder.addAddedParameters(parameterMarkerIndex + 1, addedParameters);
        }
    }
}

