/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.aware.EncryptRuleAware;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.impl.EncryptAssignmentParameterRewriter;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.impl.EncryptInsertValueParameterRewriter;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter.impl.EncryptPredicateParameterRewriter;
import org.apache.shardingsphere.core.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.core.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.aware.TableMetasAware;
import org.apache.shardingsphere.core.rule.EncryptRule;

public final class EncryptParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final EncryptRule encryptRule;
    private final boolean queryWithCipherColumn;

    @Override
    public Collection<ParameterRewriter> getParameterRewriters(TableMetas tableMetas) {
        Collection<ParameterRewriter> result = this.getParameterRewriters();
        for (ParameterRewriter each : result) {
            this.setUpParameterRewriters(each, tableMetas);
        }
        return result;
    }

    private Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        result.add(new EncryptAssignmentParameterRewriter());
        result.add(new EncryptPredicateParameterRewriter());
        result.add(new EncryptInsertValueParameterRewriter());
        return result;
    }

    private void setUpParameterRewriters(ParameterRewriter parameterRewriter, TableMetas tableMetas) {
        if (parameterRewriter instanceof TableMetasAware) {
            ((TableMetasAware)((Object)parameterRewriter)).setTableMetas(tableMetas);
        }
        if (parameterRewriter instanceof EncryptRuleAware) {
            ((EncryptRuleAware)((Object)parameterRewriter)).setEncryptRule(this.encryptRule);
        }
        if (parameterRewriter instanceof QueryWithCipherColumnAware) {
            ((QueryWithCipherColumnAware)((Object)parameterRewriter)).setQueryWithCipherColumn(this.queryWithCipherColumn);
        }
    }

    @ConstructorProperties(value={"encryptRule", "queryWithCipherColumn"})
    public EncryptParameterRewriterBuilder(EncryptRule encryptRule, boolean queryWithCipherColumn) {
        this.encryptRule = encryptRule;
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

