/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt.parameter;

import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.aware.EncryptRuleAware;
import org.apache.shardingsphere.core.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.core.rule.EncryptRule;

public abstract class EncryptParameterRewriter
implements ParameterRewriter,
EncryptRuleAware {
    private EncryptRule encryptRule;

    @Override
    public final boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return this.isNeedRewriteForEncrypt(sqlStatementContext) && this.isNeedEncrypt(sqlStatementContext);
    }

    protected abstract boolean isNeedRewriteForEncrypt(SQLStatementContext var1);

    private boolean isNeedEncrypt(SQLStatementContext sqlStatementContext) {
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            if (!this.encryptRule.findEncryptTable(each).isPresent()) continue;
            return true;
        }
        return false;
    }

    public EncryptRule getEncryptRule() {
        return this.encryptRule;
    }

    @Override
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

