/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.SubqueryPredicateSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.value.PredicateBetweenRightValue;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.value.PredicateCompareRightValue;
import org.apache.shardingsphere.core.parse.sql.segment.dml.predicate.value.PredicateInRightValue;
import org.apache.shardingsphere.core.parse.sql.statement.generic.WhereSegmentAvailable;
import org.apache.shardingsphere.core.preprocessor.segment.table.TablesContext;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.EncryptCondition;
import org.apache.shardingsphere.core.rule.EncryptRule;

public final class EncryptConditionEngine {
    private final EncryptRule encryptRule;
    private final TableMetas tableMetas;

    public List<EncryptCondition> createEncryptConditions(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext.getSqlStatement() instanceof WhereSegmentAvailable)) {
            return Collections.emptyList();
        }
        Optional whereSegment = ((WhereSegmentAvailable)sqlStatementContext.getSqlStatement()).getWhere();
        if (!whereSegment.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        for (AndPredicate each : ((WhereSegment)whereSegment.get()).getAndPredicates()) {
            result.addAll(this.createEncryptConditions(each, sqlStatementContext.getTablesContext()));
        }
        for (AndPredicate each : sqlStatementContext.getSqlStatement().findSQLSegments(SubqueryPredicateSegment.class)) {
            for (AndPredicate andPredicate : each.getAndPredicates()) {
                result.addAll(this.createEncryptConditions(andPredicate, sqlStatementContext.getTablesContext()));
            }
        }
        return result;
    }

    private Collection<EncryptCondition> createEncryptConditions(AndPredicate andPredicate, TablesContext tablesContext) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        HashSet<Integer> stopIndexes = new HashSet<Integer>();
        for (PredicateSegment predicate : andPredicate.getPredicates()) {
            Optional<EncryptCondition> condition;
            if (!stopIndexes.add(predicate.getStopIndex()) || !(condition = this.createEncryptCondition(predicate, tablesContext)).isPresent()) continue;
            result.add((EncryptCondition)condition.get());
        }
        return result;
    }

    private Optional<EncryptCondition> createEncryptCondition(PredicateSegment predicateSegment, TablesContext tablesContext) {
        Optional tableName = tablesContext.findTableName(predicateSegment.getColumn(), this.tableMetas);
        return tableName.isPresent() && this.encryptRule.findShardingEncryptor((String)tableName.get(), predicateSegment.getColumn().getName()).isPresent() ? this.createEncryptCondition(predicateSegment, (String)tableName.get()) : Optional.absent();
    }

    private Optional<EncryptCondition> createEncryptCondition(PredicateSegment predicateSegment, String tableName) {
        if (predicateSegment.getRightValue() instanceof PredicateCompareRightValue) {
            PredicateCompareRightValue compareRightValue = (PredicateCompareRightValue)predicateSegment.getRightValue();
            return this.isSupportedOperator(compareRightValue.getOperator()) ? EncryptConditionEngine.createCompareEncryptCondition(tableName, predicateSegment, compareRightValue) : Optional.absent();
        }
        if (predicateSegment.getRightValue() instanceof PredicateInRightValue) {
            return EncryptConditionEngine.createInEncryptCondition(tableName, predicateSegment, (PredicateInRightValue)predicateSegment.getRightValue());
        }
        if (predicateSegment.getRightValue() instanceof PredicateBetweenRightValue) {
            throw new ShardingException("The SQL clause 'BETWEEN...AND...' is unsupported in encrypt rule.", new Object[0]);
        }
        return Optional.absent();
    }

    private static Optional<EncryptCondition> createCompareEncryptCondition(String tableName, PredicateSegment predicateSegment, PredicateCompareRightValue compareRightValue) {
        return compareRightValue.getExpression() instanceof SimpleExpressionSegment ? Optional.of((Object)new EncryptCondition(predicateSegment.getColumn().getName(), tableName, compareRightValue.getExpression().getStartIndex(), predicateSegment.getStopIndex(), compareRightValue.getExpression())) : Optional.absent();
    }

    private static Optional<EncryptCondition> createInEncryptCondition(String tableName, PredicateSegment predicateSegment, PredicateInRightValue inRightValue) {
        LinkedList<ExpressionSegment> expressionSegments = new LinkedList<ExpressionSegment>();
        for (ExpressionSegment each : inRightValue.getSqlExpressions()) {
            if (!(each instanceof SimpleExpressionSegment)) continue;
            expressionSegments.add(each);
        }
        return expressionSegments.isEmpty() ? Optional.absent() : Optional.of((Object)new EncryptCondition(predicateSegment.getColumn().getName(), tableName, ((ExpressionSegment)inRightValue.getSqlExpressions().iterator().next()).getStartIndex(), predicateSegment.getStopIndex(), expressionSegments));
    }

    private boolean isSupportedOperator(String operator) {
        return "=".equals(operator) || "<>".equals(operator) || "!=".equals(operator);
    }

    @ConstructorProperties(value={"encryptRule", "tableMetas"})
    public EncryptConditionEngine(EncryptRule encryptRule, TableMetas tableMetas) {
        this.encryptRule = encryptRule;
        this.tableMetas = tableMetas;
    }
}

