/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.feature.encrypt;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.constant.ShardingOperator;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.core.parse.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class EncryptCondition {
    private final String columnName;
    private final String tableName;
    private final int startIndex;
    private final int stopIndex;
    private final ShardingOperator operator;
    private final Map<Integer, Integer> positionIndexMap = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Object> positionValueMap = new LinkedHashMap<Integer, Object>();

    public EncryptCondition(String columnName, String tableName, int startIndex, int stopIndex, ExpressionSegment expressionSegment) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.operator = ShardingOperator.EQUAL;
        this.putPositionMap(0, expressionSegment);
    }

    public EncryptCondition(String columnName, String tableName, int startIndex, int stopIndex, List<ExpressionSegment> expressionSegments) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.operator = ShardingOperator.IN;
        int count = 0;
        for (ExpressionSegment each : expressionSegments) {
            this.putPositionMap(count, each);
            ++count;
        }
    }

    private void putPositionMap(int position, ExpressionSegment expressionSegment) {
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            this.positionIndexMap.put(position, ((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex());
        } else if (expressionSegment instanceof LiteralExpressionSegment) {
            this.positionValueMap.put(position, ((LiteralExpressionSegment)expressionSegment).getLiterals());
        }
    }

    public List<Object> getValues(List<Object> parameters) {
        ArrayList<Object> result = new ArrayList<Object>(this.positionValueMap.values());
        for (Map.Entry<Integer, Integer> entry : this.positionIndexMap.entrySet()) {
            Object parameter = parameters.get(entry.getValue());
            if (entry.getKey() < result.size()) {
                result.add(entry.getKey(), parameter);
                continue;
            }
            result.add(parameter);
        }
        return result;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getStopIndex() {
        return this.stopIndex;
    }

    public ShardingOperator getOperator() {
        return this.operator;
    }

    public Map<Integer, Integer> getPositionIndexMap() {
        return this.positionIndexMap;
    }

    public Map<Integer, Object> getPositionValueMap() {
        return this.positionValueMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptCondition)) {
            return false;
        }
        EncryptCondition other = (EncryptCondition)o;
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        if (this.getStartIndex() != other.getStartIndex()) {
            return false;
        }
        if (this.getStopIndex() != other.getStopIndex()) {
            return false;
        }
        ShardingOperator this$operator = this.getOperator();
        ShardingOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        Map<Integer, Integer> this$positionIndexMap = this.getPositionIndexMap();
        Map<Integer, Integer> other$positionIndexMap = other.getPositionIndexMap();
        if (this$positionIndexMap == null ? other$positionIndexMap != null : !((Object)this$positionIndexMap).equals(other$positionIndexMap)) {
            return false;
        }
        Map<Integer, Object> this$positionValueMap = this.getPositionValueMap();
        Map<Integer, Object> other$positionValueMap = other.getPositionValueMap();
        return !(this$positionValueMap == null ? other$positionValueMap != null : !((Object)this$positionValueMap).equals(other$positionValueMap));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 0 : $columnName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 0 : $tableName.hashCode());
        result = result * 59 + this.getStartIndex();
        result = result * 59 + this.getStopIndex();
        ShardingOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 0 : $operator.hashCode());
        Map<Integer, Integer> $positionIndexMap = this.getPositionIndexMap();
        result = result * 59 + ($positionIndexMap == null ? 0 : ((Object)$positionIndexMap).hashCode());
        Map<Integer, Object> $positionValueMap = this.getPositionValueMap();
        result = result * 59 + ($positionValueMap == null ? 0 : ((Object)$positionValueMap).hashCode());
        return result;
    }

    public String toString() {
        return "EncryptCondition(columnName=" + this.getColumnName() + ", tableName=" + this.getTableName() + ", startIndex=" + this.getStartIndex() + ", stopIndex=" + this.getStopIndex() + ", operator=" + this.getOperator() + ", positionIndexMap=" + this.getPositionIndexMap() + ", positionValueMap=" + this.getPositionValueMap() + ")";
    }
}

