/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rewrite.context;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.core.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.core.rewrite.sql.SQLBuilder;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.SQLTokenGenerators;
import org.apache.shardingsphere.core.rewrite.sql.token.generator.builder.DefaultTokenGeneratorBuilder;
import org.apache.shardingsphere.core.rewrite.sql.token.pojo.SQLToken;

public final class SQLRewriteContext {
    private final TableMetas tableMetas;
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLTokenGenerators sqlTokenGenerators = new SQLTokenGenerators();
    private final ParameterBuilder parameterBuilder;

    public SQLRewriteContext(TableMetas tableMetas, SQLStatementContext sqlStatementContext, String sql, List<Object> parameters) {
        this.tableMetas = tableMetas;
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = parameters;
        this.addSQLTokenGenerators(new DefaultTokenGeneratorBuilder().getSQLTokenGenerators());
        this.parameterBuilder = sqlStatementContext instanceof InsertSQLStatementContext ? new GroupedParameterBuilder(((InsertSQLStatementContext)sqlStatementContext).getGroupedParameters()) : new StandardParameterBuilder(parameters);
    }

    public void addSQLTokenGenerators(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        this.sqlTokenGenerators.addAll(sqlTokenGenerators);
    }

    public void generateSQLTokens() {
        this.sqlTokens.addAll(this.sqlTokenGenerators.generateSQLTokens(this.sqlStatementContext, this.parameters, this.tableMetas));
    }

    public SQLBuilder getSQLBuilder() {
        return new SQLBuilder(this.sql, this.sqlTokens);
    }

    public TableMetas getTableMetas() {
        return this.tableMetas;
    }

    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public ParameterBuilder getParameterBuilder() {
        return this.parameterBuilder;
    }
}

