/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.pagination;

import java.sql.SQLException;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.underlying.merge.result.MergedResult;
import org.apache.shardingsphere.underlying.merge.result.impl.decorator.DecoratorMergedResult;

public final class TopAndRowNumberDecoratorMergedResult
extends DecoratorMergedResult {
    private final PaginationContext pagination;
    private final boolean skipAll;
    private long rowNumber;

    public TopAndRowNumberDecoratorMergedResult(MergedResult mergedResult, PaginationContext pagination) throws SQLException {
        super(mergedResult);
        this.pagination = pagination;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        long end = this.pagination.getActualOffset();
        int i = 0;
        while ((long)i < end) {
            if (!this.getMergedResult().next()) {
                return true;
            }
            ++i;
        }
        this.rowNumber = end + 1L;
        return false;
    }

    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (!this.pagination.getActualRowCount().isPresent()) {
            return this.getMergedResult().next();
        }
        return this.rowNumber++ <= (Long)this.pagination.getActualRowCount().get() && this.getMergedResult().next();
    }
}

