/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.groupby;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.sharding.merge.dql.groupby.GroupByRowComparator;
import org.apache.shardingsphere.sharding.merge.dql.groupby.GroupByValue;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AggregationUnitFactory;
import org.apache.shardingsphere.sql.parser.binder.metadata.column.ColumnMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.table.TableMetaData;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.underlying.executor.QueryResult;
import org.apache.shardingsphere.underlying.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.underlying.merge.result.impl.memory.MemoryQueryResultRow;

public final class GroupByMemoryMergedResult
extends MemoryMergedResult<ShardingRule> {
    public GroupByMemoryMergedResult(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, SchemaMetaData schemaMetaData) throws SQLException {
        super(null, schemaMetaData, (SQLStatementContext)selectStatementContext, queryResults);
    }

    protected List<MemoryQueryResultRow> init(ShardingRule shardingRule, SchemaMetaData schemaMetaData, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        SelectStatementContext selectStatementContext = (SelectStatementContext)sqlStatementContext;
        HashMap<GroupByValue, MemoryQueryResultRow> dataMap = new HashMap<GroupByValue, MemoryQueryResultRow>(1024);
        HashMap<GroupByValue, Map<AggregationProjection, AggregationUnit>> aggregationMap = new HashMap<GroupByValue, Map<AggregationProjection, AggregationUnit>>(1024);
        for (QueryResult each : queryResults) {
            while (each.next()) {
                GroupByValue groupByValue = new GroupByValue(each, selectStatementContext.getGroupByContext().getItems());
                this.initForFirstGroupByValue(selectStatementContext, each, groupByValue, dataMap, aggregationMap);
                this.aggregate(selectStatementContext, each, groupByValue, aggregationMap);
            }
        }
        this.setAggregationValueToMemoryRow(selectStatementContext, dataMap, aggregationMap);
        List<Boolean> valueCaseSensitive = queryResults.isEmpty() ? Collections.emptyList() : this.getValueCaseSensitive(queryResults.iterator().next(), selectStatementContext, schemaMetaData);
        return this.getMemoryResultSetRows(selectStatementContext, dataMap, valueCaseSensitive);
    }

    private void initForFirstGroupByValue(SelectStatementContext selectStatementContext, QueryResult queryResult, GroupByValue groupByValue, Map<GroupByValue, MemoryQueryResultRow> dataMap, Map<GroupByValue, Map<AggregationProjection, AggregationUnit>> aggregationMap) throws SQLException {
        if (!dataMap.containsKey(groupByValue)) {
            dataMap.put(groupByValue, new MemoryQueryResultRow(queryResult));
        }
        if (!aggregationMap.containsKey(groupByValue)) {
            ImmutableMap map = Maps.toMap((Iterable)selectStatementContext.getProjectionsContext().getAggregationProjections(), input -> AggregationUnitFactory.create(input.getType(), input instanceof AggregationDistinctProjection));
            aggregationMap.put(groupByValue, (Map<AggregationProjection, AggregationUnit>)map);
        }
    }

    private void aggregate(SelectStatementContext selectStatementContext, QueryResult queryResult, GroupByValue groupByValue, Map<GroupByValue, Map<AggregationProjection, AggregationUnit>> aggregationMap) throws SQLException {
        for (AggregationProjection each : selectStatementContext.getProjectionsContext().getAggregationProjections()) {
            ArrayList values = new ArrayList(2);
            if (each.getDerivedAggregationProjections().isEmpty()) {
                values.add(this.getAggregationValue(queryResult, each));
            } else {
                for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                    values.add(this.getAggregationValue(queryResult, derived));
                }
            }
            aggregationMap.get(groupByValue).get(each).merge(values);
        }
    }

    private Comparable<?> getAggregationValue(QueryResult queryResult, AggregationProjection aggregationProjection) throws SQLException {
        Object result = queryResult.getValue(aggregationProjection.getIndex(), Object.class);
        Preconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, (Object)"Aggregation value must implements Comparable");
        return (Comparable)result;
    }

    private void setAggregationValueToMemoryRow(SelectStatementContext selectStatementContext, Map<GroupByValue, MemoryQueryResultRow> dataMap, Map<GroupByValue, Map<AggregationProjection, AggregationUnit>> aggregationMap) {
        for (Map.Entry<GroupByValue, MemoryQueryResultRow> entry : dataMap.entrySet()) {
            for (AggregationProjection each : selectStatementContext.getProjectionsContext().getAggregationProjections()) {
                entry.getValue().setCell(each.getIndex(), aggregationMap.get(entry.getKey()).get(each).getResult());
            }
        }
    }

    private List<Boolean> getValueCaseSensitive(QueryResult queryResult, SelectStatementContext selectStatementContext, SchemaMetaData schemaMetaData) throws SQLException {
        ArrayList result = Lists.newArrayList((Object[])new Boolean[]{false});
        for (int columnIndex = 1; columnIndex <= queryResult.getColumnCount(); ++columnIndex) {
            result.add(this.getValueCaseSensitiveFromTables(queryResult, selectStatementContext, schemaMetaData, columnIndex));
        }
        return result;
    }

    private boolean getValueCaseSensitiveFromTables(QueryResult queryResult, SelectStatementContext selectStatementContext, SchemaMetaData schemaMetaData, int columnIndex) throws SQLException {
        for (SimpleTableSegment each : selectStatementContext.getAllTables()) {
            String columnName;
            String tableName = each.getTableName().getIdentifier().getValue();
            TableMetaData tableMetaData = schemaMetaData.get(tableName);
            Map columns = tableMetaData.getColumns();
            if (!columns.containsKey(columnName = queryResult.getColumnName(columnIndex))) continue;
            return ((ColumnMetaData)columns.get(columnName)).isCaseSensitive();
        }
        return false;
    }

    private List<MemoryQueryResultRow> getMemoryResultSetRows(SelectStatementContext selectStatementContext, Map<GroupByValue, MemoryQueryResultRow> dataMap, List<Boolean> valueCaseSensitive) {
        ArrayList<MemoryQueryResultRow> result = new ArrayList<MemoryQueryResultRow>(dataMap.values());
        result.sort(new GroupByRowComparator(selectStatementContext, valueCaseSensitive));
        return result;
    }
}

