/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dql.orderby;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.dql.orderby.CompareUtil;
import org.apache.shardingsphere.core.preprocessor.segment.select.orderby.OrderByItem;

public final class OrderByValue
implements Comparable<OrderByValue> {
    private final QueryResult queryResult;
    private final Collection<OrderByItem> orderByItems;
    private final List<Boolean> orderValuesCaseSensitive;
    private List<Comparable<?>> orderValues;

    public OrderByValue(QueryResult queryResult, Collection<OrderByItem> orderByItems) {
        this.queryResult = queryResult;
        this.orderByItems = orderByItems;
        this.orderValuesCaseSensitive = this.getOrderValuesCaseSensitive();
    }

    private List<Boolean> getOrderValuesCaseSensitive() {
        ArrayList<Boolean> result = new ArrayList<Boolean>(this.orderByItems.size());
        for (OrderByItem each : this.orderByItems) {
            result.add(this.queryResult.isCaseSensitive(each.getIndex()));
        }
        return result;
    }

    public boolean next() throws SQLException {
        boolean result = this.queryResult.next();
        this.orderValues = result ? this.getOrderValues() : Collections.emptyList();
        return result;
    }

    private List<Comparable<?>> getOrderValues() throws SQLException {
        ArrayList result = new ArrayList(this.orderByItems.size());
        for (OrderByItem each : this.orderByItems) {
            Object value = this.queryResult.getValue(each.getIndex(), Object.class);
            Preconditions.checkState((null == value || value instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            result.add((Comparable)value);
        }
        return result;
    }

    @Override
    public int compareTo(OrderByValue o) {
        int i = 0;
        for (OrderByItem each : this.orderByItems) {
            int result = CompareUtil.compareTo(this.orderValues.get(i), o.orderValues.get(i), each.getSegment().getOrderDirection(), each.getSegment().getNullOrderDirection(), this.orderValuesCaseSensitive.get(i));
            if (0 != result) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }
}

