/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dql.common;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;

public class MemoryQueryResultRow {
    private final Object[] data;

    public MemoryQueryResultRow(QueryResult queryResult) throws SQLException {
        this.data = this.load(queryResult);
    }

    private Object[] load(QueryResult queryResult) throws SQLException {
        int columnCount = queryResult.getColumnCount();
        Object[] result = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            result[i] = queryResult.getValue(i + 1, Object.class);
        }
        return result;
    }

    public Object getCell(int columnIndex) {
        Preconditions.checkArgument((columnIndex > 0 && columnIndex < this.data.length + 1 ? 1 : 0) != 0);
        return this.data[columnIndex - 1];
    }

    public void setCell(int columnIndex, Object value) {
        Preconditions.checkArgument((columnIndex > 0 && columnIndex < this.data.length + 1 ? 1 : 0) != 0);
        this.data[columnIndex - 1] = value;
    }
}

