/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dql.common;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Calendar;
import java.util.Map;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dql.common.MemoryQueryResultRow;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public abstract class MemoryMergedResult
implements MergedResult {
    private final Map<String, Integer> labelAndIndexMap;
    private MemoryQueryResultRow currentResultSetRow;
    private boolean wasNull;

    protected final void resetLabelAndIndexMap(Map<String, Integer> labelAndIndexMap) {
        this.labelAndIndexMap.clear();
        this.labelAndIndexMap.putAll(labelAndIndexMap);
    }

    @Override
    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final Object getValue(String columnLabel, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        Object result = this.currentResultSetRow.getCell(this.labelAndIndexMap.containsKey(columnLabel) ? this.labelAndIndexMap.get(columnLabel) : this.labelAndIndexMap.get(SQLUtil.getExactlyValue((String)columnLabel)));
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) {
        Object result = this.currentResultSetRow.getCell(this.labelAndIndexMap.get(columnLabel));
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final InputStream getInputStream(String columnLabel, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final boolean wasNull() {
        return this.wasNull;
    }

    @ConstructorProperties(value={"labelAndIndexMap"})
    public MemoryMergedResult(Map<String, Integer> labelAndIndexMap) {
        this.labelAndIndexMap = labelAndIndexMap;
    }

    public void setCurrentResultSetRow(MemoryQueryResultRow currentResultSetRow) {
        this.currentResultSetRow = currentResultSetRow;
    }
}

