/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dql;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.shardingsphere.core.database.DatabaseTypes;
import org.apache.shardingsphere.core.execute.sql.execute.result.AggregationDistinctQueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.result.DistinctQueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.MergeEngine;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dql.groupby.GroupByMemoryMergedResult;
import org.apache.shardingsphere.core.merge.dql.groupby.GroupByStreamMergedResult;
import org.apache.shardingsphere.core.merge.dql.iterator.IteratorStreamMergedResult;
import org.apache.shardingsphere.core.merge.dql.orderby.OrderByStreamMergedResult;
import org.apache.shardingsphere.core.merge.dql.pagination.LimitDecoratorMergedResult;
import org.apache.shardingsphere.core.merge.dql.pagination.RowNumberDecoratorMergedResult;
import org.apache.shardingsphere.core.merge.dql.pagination.TopAndRowNumberDecoratorMergedResult;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.parse.util.SQLUtil;
import org.apache.shardingsphere.core.preprocessor.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.SelectSQLStatementContext;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.spi.database.DatabaseType;

public final class DQLMergeEngine
implements MergeEngine {
    private final DatabaseType databaseType;
    private final SQLRouteResult routeResult;
    private final SelectSQLStatementContext selectSQLStatementContext;
    private final List<QueryResult> queryResults;
    private final Map<String, Integer> columnLabelIndexMap;

    public DQLMergeEngine(DatabaseType databaseType, TableMetas tableMetas, SQLRouteResult routeResult, List<QueryResult> queryResults) throws SQLException {
        this.databaseType = databaseType;
        this.routeResult = routeResult;
        this.selectSQLStatementContext = (SelectSQLStatementContext)routeResult.getSqlStatementContext();
        this.queryResults = this.getRealQueryResults(tableMetas, queryResults);
        this.columnLabelIndexMap = this.getColumnLabelIndexMap(this.queryResults.get(0));
    }

    private List<QueryResult> getRealQueryResults(TableMetas tableMetas, List<QueryResult> queryResults) throws SQLException {
        List<QueryResult> result = queryResults;
        if (1 == result.size()) {
            return result;
        }
        List aggregationDistinctProjections = this.selectSQLStatementContext.getProjectionsContext().getAggregationDistinctProjections();
        if (!aggregationDistinctProjections.isEmpty()) {
            result = this.getDividedQueryResults((DistinctQueryResult)new AggregationDistinctQueryResult(queryResults, aggregationDistinctProjections));
        }
        if (this.isDistinctRowSelectItems()) {
            result = this.getDividedQueryResults(new DistinctQueryResult(queryResults, this.selectSQLStatementContext.getColumnLabels(tableMetas)));
        }
        return result.isEmpty() ? queryResults : result;
    }

    private List<QueryResult> getDividedQueryResults(DistinctQueryResult distinctQueryResult) {
        return Lists.transform((List)distinctQueryResult.divide(), (Function)new Function<DistinctQueryResult, QueryResult>(){

            public QueryResult apply(DistinctQueryResult input) {
                return input;
            }
        });
    }

    private boolean isDistinctRowSelectItems() {
        return this.selectSQLStatementContext.getProjectionsContext().isDistinctRow() && this.selectSQLStatementContext.getGroupByContext().getItems().isEmpty();
    }

    private Map<String, Integer> getColumnLabelIndexMap(QueryResult queryResult) throws SQLException {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        for (int i = queryResult.getColumnCount(); i > 0; --i) {
            result.put(SQLUtil.getExactlyValue((String)queryResult.getColumnLabel(i)), i);
        }
        return result;
    }

    @Override
    public MergedResult merge() throws SQLException {
        if (1 == this.queryResults.size()) {
            return new IteratorStreamMergedResult(this.queryResults);
        }
        this.selectSQLStatementContext.setIndexes(this.columnLabelIndexMap);
        return this.decorate(this.build());
    }

    private MergedResult build() throws SQLException {
        if (!this.selectSQLStatementContext.getGroupByContext().getItems().isEmpty() || !this.selectSQLStatementContext.getProjectionsContext().getAggregationProjections().isEmpty()) {
            return this.getGroupByMergedResult();
        }
        if (!this.selectSQLStatementContext.getOrderByContext().getItems().isEmpty()) {
            return new OrderByStreamMergedResult(this.queryResults, this.selectSQLStatementContext.getOrderByContext().getItems());
        }
        return new IteratorStreamMergedResult(this.queryResults);
    }

    private MergedResult getGroupByMergedResult() throws SQLException {
        return this.selectSQLStatementContext.isSameGroupByAndOrderByItems() ? new GroupByStreamMergedResult(this.columnLabelIndexMap, this.queryResults, this.selectSQLStatementContext) : new GroupByMemoryMergedResult(this.columnLabelIndexMap, this.queryResults, this.selectSQLStatementContext);
    }

    private MergedResult decorate(MergedResult mergedResult) throws SQLException {
        PaginationContext paginationContext = ((SelectSQLStatementContext)this.routeResult.getSqlStatementContext()).getPaginationContext();
        if (!paginationContext.isHasPagination() || 1 == this.queryResults.size()) {
            return mergedResult;
        }
        String trunkDatabaseName = DatabaseTypes.getTrunkDatabaseType((String)this.databaseType.getName()).getName();
        if ("MySQL".equals(trunkDatabaseName) || "PostgreSQL".equals(trunkDatabaseName)) {
            return new LimitDecoratorMergedResult(mergedResult, paginationContext);
        }
        if ("Oracle".equals(trunkDatabaseName)) {
            return new RowNumberDecoratorMergedResult(mergedResult, paginationContext);
        }
        if ("SQLServer".equals(trunkDatabaseName)) {
            return new TopAndRowNumberDecoratorMergedResult(mergedResult, paginationContext);
        }
        return mergedResult;
    }

    public Map<String, Integer> getColumnLabelIndexMap() {
        return this.columnLabelIndexMap;
    }
}

