/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge;

import java.sql.SQLException;
import java.util.List;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.MergeEngine;
import org.apache.shardingsphere.core.merge.TransparentMergeEngine;
import org.apache.shardingsphere.core.merge.dal.DALMergeEngine;
import org.apache.shardingsphere.core.merge.dql.DQLMergeEngine;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.parse.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.core.preprocessor.statement.impl.SelectSQLStatementContext;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.spi.database.DatabaseType;

public final class MergeEngineFactory {
    public static MergeEngine newInstance(DatabaseType databaseType, ShardingRule shardingRule, SQLRouteResult routeResult, TableMetas tableMetas, List<QueryResult> queryResults) throws SQLException {
        if (routeResult.getSqlStatementContext() instanceof SelectSQLStatementContext) {
            return new DQLMergeEngine(databaseType, tableMetas, routeResult, queryResults);
        }
        if (routeResult.getSqlStatementContext().getSqlStatement() instanceof DALStatement) {
            return new DALMergeEngine(shardingRule, queryResults, routeResult.getSqlStatementContext(), tableMetas);
        }
        return new TransparentMergeEngine(queryResults);
    }

    private MergeEngineFactory() {
    }
}

